/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.auth.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.AuditSignService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.auth.service.bean.CertInfoDTO;
import com.xdja.pki.auth.service.bean.CertStatusEnum;
import com.xdja.pki.auth.service.bean.DigestAlgEnum;
import com.xdja.pki.auth.service.bean.KeyAlgEnum;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.exception.JSONException;
import com.xdja.pki.core.utils.JsonMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.ContentCachingRequestWrapper;

@Aspect
@Component
public class AuditSignAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AuditSignService auditSignService;
    @Resource
    private AuditLogService auditLogService;

    @Pointcut(value="@annotation(com.xdja.pki.auth.annotation.AuditSign)")
    public void annotationPointcut() {
    }

    @Pointcut(value="@annotation(com.xdja.pki.auth.annotation.AuditLogSign)")
    public void auditLogPointcut() {
    }

    @Around(value="annotationPointcut() || auditLogPointcut()")
    public Object authAdmin(ProceedingJoinPoint jp) {
        HttpServletResponse response = null;
        try {
            long tmpOffsetTime;
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)servletRequestAttributes.getRequest();
            response = servletRequestAttributes.getResponse();
            ContentCachingRequestWrapper request = null;
            request = !(requestWrapper instanceof ContentCachingRequestWrapper) ? (ContentCachingRequestWrapper)requestWrapper.getRequest() : (ContentCachingRequestWrapper)requestWrapper;
            String sn = request.getHeader("sn");
            String timestamp = request.getHeader("timestamp");
            String sign = request.getHeader("sign");
            if (StringUtils.isBlank((CharSequence)sn) || StringUtils.isBlank((CharSequence)timestamp) || StringUtils.isBlank((CharSequence)sign)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5 [sn={},timestamp={},sign={}]", new Object[]{sn, timestamp, sign});
                }
                return this.auditSignService.getIllegalParamError(response);
            }
            long minusTime = System.currentTimeMillis() - Long.valueOf(timestamp);
            if (minusTime > (tmpOffsetTime = (long)(this.auditSignService.getOffsetTime() * 60 * 1000))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5ba2\u6237\u7aef\u65f6\u95f4\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u4e0d\u4e00\u81f4");
                }
                return this.auditSignService.getVerifyTimeError(response);
            }
            byte[] sourceData = this.constructBusinessData(request, timestamp);
            CoreResult result = this.verifySign(sn, sign, sourceData, response);
            if (!result.isSuccess()) {
                return result.getInfo();
            }
            AuditSignBean bean = new AuditSignBean();
            bean.setSn(sn);
            bean.setKeyAlg(Integer.valueOf(String.valueOf(result.getInfo())));
            bean.setTimestamp(timestamp);
            bean.setSign(sign);
            bean.setIp(request.getRemoteAddr());
            bean.setContent(new String(sourceData));
            Object[] args = jp.getArgs();
            Object item = null;
            for (int i = 0; i < args.length; ++i) {
                item = args[i];
                if (null == item || item.getClass() != AuditSignBean.class) continue;
                args[i] = bean;
                break;
            }
            return jp.proceed(args);
        }
        catch (Throwable e) {
            this.logger.error("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25", e);
            return this.auditSignService.getServerInternalError(response);
        }
    }

    @AfterReturning(pointcut="auditLogPointcut()", returning="returnValue")
    public Object saveAuditLog(JoinPoint point, Object returnValue) {
        this.logger.debug(" \u901a\u7528\u5ba1\u8ba1 \u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7 \u5f00\u59cb ");
        Object[] args = point.getArgs();
        AuditSignBean auditSignBean = new AuditSignBean();
        Object item = null;
        for (int i = 0; i < args.length; ++i) {
            item = args[i];
            if (null == item || item.getClass() != AuditSignBean.class) continue;
            auditSignBean = (AuditSignBean)args[i];
            break;
        }
        if (!(returnValue instanceof CoreResult)) {
            return returnValue;
        }
        CoreResult result = (CoreResult)returnValue;
        if (!result.isSuccess()) {
            return result.getErrorBean();
        }
        CoreResult.AuditLogDetail auditLogDetail = result.getAuditLogDetail();
        this.auditLogService.save(auditLogDetail.getOperatorType(), auditLogDetail.getOperatorContext(), auditLogDetail.getOperatorResult(), auditSignBean.getSign());
        this.logger.debug(" \u901a\u7528\u5ba1\u8ba1 \u4fdd\u5b58\u5ba1\u8ba1\u65e5\u5fd7 \u7ed3\u675f ");
        return result.getInfo();
    }

    private CoreResult verifySign(String sn, String sign, byte[] businessData, HttpServletResponse response) throws Exception {
        int degistAlg;
        ContentInfo contentInfo = ContentInfo.getInstance((Object)Base64.decode((String)sign));
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent().toASN1Primitive());
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signedData.getSignerInfos().getObjectAt(0));
        byte[] signData = signerInfo.getEncryptedDigest().getOctets();
        byte[] businessDigest = this.auditSignService.getDigest(businessData);
        String signAlg = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().getId();
        String digestAlg = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
        int keyAlg = this.auditSignService.getSystemKeyAlg();
        if (signAlg.equals(GMObjectIdentifiers.sm2sign.getId()) && keyAlg == KeyAlgEnum.SM2.value) {
            if (!digestAlg.equals(GMObjectIdentifiers.sm3.getId())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff0c[signAlg={},digestAlg={}]", (Object)signAlg, (Object)digestAlg);
                }
                return CoreResult.failure((Object)this.auditSignService.getIllegalSignAlgError(response));
            }
            degistAlg = DigestAlgEnum.SM3.value;
        } else if (signAlg.equals(PKCSObjectIdentifiers.rsaEncryption.getId()) && keyAlg == KeyAlgEnum.RSA.value) {
            if (!digestAlg.equals(NISTObjectIdentifiers.id_sha256.getId())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff0c[signAlg={},digestAlg={}]", (Object)signAlg, (Object)digestAlg);
                }
                return CoreResult.failure((Object)this.auditSignService.getIllegalSignAlgError(response));
            }
            degistAlg = DigestAlgEnum.SHA256.value;
        } else if (signAlg.equals(X9ObjectIdentifiers.prime256v1.getId()) && keyAlg == KeyAlgEnum.NIST.value) {
            if (!digestAlg.equals(NISTObjectIdentifiers.id_sha256.getId())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff0c[signAlg={},digestAlg={}]", (Object)signAlg, (Object)digestAlg);
                }
                return CoreResult.failure((Object)this.auditSignService.getIllegalSignAlgError(response));
            }
            degistAlg = DigestAlgEnum.SHA256.value;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff0c[signAlg={},digestAlg={},systemKeyAlg={}]", new Object[]{signAlg, digestAlg, KeyAlgEnum.convert((int)keyAlg).desc});
            }
            return CoreResult.failure((Object)this.auditSignService.getIllegalSignAlgError(response));
        }
        CertInfoDTO certInfo = this.auditSignService.getCertBySn(sn, keyAlg);
        if (null == certInfo) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u4e0d\u5b58\u5728");
            }
            return CoreResult.failure((Object)this.auditSignService.getCertNotExistError(response));
        }
        if (certInfo.getStatus() != CertStatusEnum.NORMAL.value) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38");
            }
            return CoreResult.failure((Object)this.auditSignService.getCertStatusError(certInfo.getStatus(), response));
        }
        if (!this.auditSignService.verifySign(keyAlg, degistAlg, certInfo.getPublicKey(), businessData, signData)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u9a8c\u8bc1\u7ba1\u7406\u5458\u64cd\u4f5c\u7b7e\u540d\u5931\u8d25");
            }
            return CoreResult.failure((Object)this.auditSignService.getVerifySignFailError(response));
        }
        return CoreResult.success((Object)keyAlg);
    }

    private byte[] constructBusinessData(ContentCachingRequestWrapper request, String timestamp) throws JSONException, UnsupportedEncodingException {
        StringBuilder content = new StringBuilder();
        content.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            String[] queryArray;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u8bf7\u6c42QueryString\u53c2\u6570\uff1a{}", (Object)queryString);
            }
            if (null != (queryArray = StringUtils.split((String)queryString, (String)"&")) && queryArray.length > 0) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                String[] tempArray = null;
                for (int i = 0; i < queryArray.length; ++i) {
                    String temp = queryArray[i];
                    if (!StringUtils.isNotBlank((CharSequence)temp)) continue;
                    tempArray = StringUtils.split((String)temp, (String)"=");
                    if (tempArray.length < 2) {
                        queryParams.put(tempArray[0], "");
                        continue;
                    }
                    if (tempArray[0].equals("_")) continue;
                    queryParams.put(tempArray[0], URLDecoder.decode(tempArray[1], "UTF-8"));
                }
                ArrayList queryStringKeys = new ArrayList(queryParams.keySet());
                Collections.sort(queryStringKeys);
                for (Object key : queryStringKeys) {
                    content.append(queryParams.get(key).toString());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().indexOf("multipart/form-data") != -1) {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String paramterKey = (String)parameterNames.nextElement();
                String paramterValue = request.getParameter(paramterKey);
                if (!StringUtils.isNotBlank((CharSequence)paramterValue) || paramterValue.equalsIgnoreCase("null")) continue;
                params.put(paramterKey, paramterValue);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u8bf7\u6c42form\u8868\u5355\u53c2\u6570\uff1a{}", params);
            }
            ArrayList keys = new ArrayList(params.keySet());
            Collections.sort(keys);
            String value = null;
            for (String key : keys) {
                value = (String)params.get(key);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                content.append(value);
            }
        } else {
            byte[] body = request.getContentAsByteArray();
            if (body.length > 0) {
                Map reqData = (Map)JsonMapper.alwaysMapper().fromJson(body, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)new String(body));
                }
                ArrayList keys = new ArrayList(reqData.keySet());
                Collections.sort(keys);
                Object object = null;
                String item = null;
                for (Object key : keys) {
                    object = reqData.get(key);
                    if (null == object || StringUtils.isBlank((CharSequence)(item = JsonMapper.alwaysMapper().toJson(object))) || item.equals("\"\"")) continue;
                    if (item.startsWith("\"")) {
                        item = item.substring(1, item.length() - 1);
                    }
                    content.append(item);
                }
            }
        }
        content.append(timestamp);
        String tempContent = content.toString().replace(" ", "").replace("\r", "").replace("\\r", "").replace("\n", "").replace("\\n", "").replace("\\\"", "\"");
        tempContent = URLEncoder.encode(tempContent, "UTF-8");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u901a\u7528\u5ba1\u8ba1\u9a8c\u7b7e\u539f\u6587\uff1a{}", (Object)tempContent);
        }
        return tempContent.getBytes();
    }
}

