/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DateUtils {
    public static final String FORMAT_ONE = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_TWO = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_THREE = "yyyyMMdd-HHmmss";
    public static final String FORMAT_FOUT = "yyyyMMddHHmmss";
    public static final String FORMAT_FIVE = "yyyyMMddHHmmssSSS";
    public static final String LONG_DATE_FORMAT = "yyyy-MM-dd";
    public static final String SHORT_DATE_FORMAT = "MM-dd";
    public static final String FORMAT_SIX = "yyyy-MM-dd HH:mm:ss.SSS";
    private static DateFormat UTC_T_FULL_SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static DateFormat UTC_T_FULL_X_SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static DateFormat UTC_DAY_SDF = new SimpleDateFormat("yyyy-MM-ddZ");

    public static String nowDateString() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_ONE);
        return dateFormat.format(date);
    }

    public static String getPreDayEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        return dateFormat.format(date) + " 23:59:59";
    }

    public static String getPreDayStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
        Date date = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        return dateFormat.format(date) + " 00:00:00";
    }

    public static String todayStartDateString() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        return dateFormat.format(date) + " 00:00:00";
    }

    public static String todayEndDateString() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        return dateFormat.format(date) + " 23:59:59";
    }

    public static String nowDateYmd() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String getFirstSecondOfCurrentMonth() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        return dateFormat.format(c.getTime()) + " 00:00:00";
    }

    public static String getLastSecondOfCurrentMonth() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return dateFormat.format(ca.getTime()) + " 23:59:59";
    }

    public static Date stringtoDate(String dateStr, String format) {
        Date d;
        if (format == null || "".equals(format)) {
            format = FORMAT_ONE;
        }
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String getCurrentTime() {
        return DateUtils.getCurrentTime(null);
    }

    public static String getCurrentTime(String format) {
        return DateUtils.dateToString(new Date(), format);
    }

    public static String dateToString(Date date, String format) {
        String result = "";
        if (format == null || "".equals(format)) {
            format = FORMAT_ONE;
        }
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static String getCurrentDate() {
        return DateUtils.getCurrentTime(LONG_DATE_FORMAT);
    }

    public static String getCurrentDate(String format) {
        return DateUtils.getCurrentTime(format);
    }

    public static int getCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static int getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static String getFirstByCurrMoth() {
        String currDateStr = DateUtils.getCurrentDate();
        return currDateStr.substring(0, 8) + "01";
    }

    public static String getLastDayOfCurrMoth() {
        String currDateStr = DateUtils.getCurrentDate();
        return currDateStr.substring(0, 8) + DateUtils.getDaysOfMonth(DateUtils.getCurrentYear(), DateUtils.getCurrentMonth());
    }

    public static boolean isLastDayOfTheMonth() {
        String currDateStr = DateUtils.getCurrentDate();
        return currDateStr.substring(8, 10).equals(DateUtils.getLastDayOfCurrMoth());
    }

    public static boolean isTimeOut(String datestr, int h) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_ONE);
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (date == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, h);
        date = cal.getTime();
        Date now = new Date();
        return date.before(now);
    }

    public static boolean isTimeOutM(String datestr, int m) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_ONE);
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (date == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, m);
        date = cal.getTime();
        Date now = new Date();
        return date.before(now);
    }

    public static Date getIntervalDate(Date date, int type, int amount) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(type, amount);
        return calendar.getTime();
    }

    public static String getFormatTime(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static Date strToDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_ONE);
        Date time = null;
        try {
            time = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static boolean compareToTime(String prefixStrTime, String suffixStrTime) {
        Calendar prefixCalendar = Calendar.getInstance();
        Calendar suffixCalendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_ONE);
        try {
            prefixCalendar.setTime(dateFormat.parse(prefixStrTime));
            suffixCalendar.setTime(dateFormat.parse(suffixStrTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int result = prefixCalendar.compareTo(suffixCalendar);
        return result >= 0;
    }

    public static boolean compareCurrentTime(Date date) {
        String currentTime = DateUtils.getCurrentTime();
        String time = DateUtils.getFormatTime(FORMAT_ONE, date);
        return DateUtils.compareToTime(currentTime, time);
    }

    public static Date getStartTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String returnDate = format.format(date);
        return DateUtils.strToDate(returnDate);
    }

    public static Date getStartTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String returnDate = format.format(new Date());
        return DateUtils.strToDate(returnDate);
    }

    public static boolean isInDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(LONG_DATE_FORMAT);
        String paramDate = format.format(date);
        String nowDate = format.format(new Date());
        return paramDate.equals(nowDate);
    }

    public static Map<String, Object> getStartAndEndTiem() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        map.put("endTime", calendar.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        map.put("startTime", calendar.getTime());
        return map;
    }

    public static String format2UTCTFull(Date date) {
        return UTC_T_FULL_SDF.format(date);
    }

    public static Date parseFromUTCTFull(String UTCTzFull) throws ParseException {
        return UTC_T_FULL_X_SDF.parse(UTCTzFull);
    }

    public static Date parseFromUTCDay(String UTCDay) throws ParseException {
        return UTC_DAY_SDF.parse(UTCDay);
    }

    public static long getStartMsOfUTCDay(String UTCDay) throws ParseException {
        return UTC_DAY_SDF.parse(UTCDay).getTime();
    }

    public static long getEndMsOfUTCDay(String UTCDay) throws ParseException {
        return UTC_DAY_SDF.parse(UTCDay).getTime() + 86400000L - 1L;
    }

    public static String long2DateStr(long time, TimeZone timeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_ONE);
        sdf.setTimeZone(timeZone);
        return sdf.format(new Date(time));
    }

    public static TimeZone getTimeZoneByDateStr(String str) {
        String offset = str.substring(10);
        if (!offset.startsWith("+") && !offset.startsWith("-")) {
            throw new IllegalArgumentException("\u65e5\u671f\u5b57\u7b26\u4e32\u683c\u5f0f\u975e\u6cd5");
        }
        return TimeZone.getTimeZone("GMT" + offset);
    }

    public static Long getDays(Date one, Date two) {
        long diff = (one.getTime() - two.getTime()) / 86400000L;
        return Math.abs(diff);
    }

    public static String plusDay(int num, String datestr, String formatStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        Date newDate = null;
        try {
            newDate = dateFormat.parse(datestr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        assert (newDate != null);
        calendar.setTime(newDate);
        calendar.add(5, num);
        Date endDate = calendar.getTime();
        return dateFormat.format(endDate);
    }

    public static String plusDay(int num, String formatStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        Calendar ca = Calendar.getInstance();
        ca.add(5, num);
        Date date = ca.getTime();
        return dateFormat.format(date);
    }

    public static String plusMinute(int num, String formatStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        Calendar ca = Calendar.getInstance();
        ca.add(12, num);
        Date date = ca.getTime();
        return dateFormat.format(date);
    }

    public static String plusSecond(int num, String formatStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        Calendar ca = Calendar.getInstance();
        ca.add(13, num);
        Date date = ca.getTime();
        return dateFormat.format(date);
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCron6(Date date) {
        String dateFormat = "ss mm HH dd MM ?";
        return DateUtils.formatDateByPattern(date, dateFormat);
    }

    public static String getCron7(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return DateUtils.formatDateByPattern(date, dateFormat);
    }
}

