/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static Logger logger = LoggerFactory.getLogger(PropertiesUtils.class);
    private static Properties properties;

    private PropertiesUtils() {
    }

    public static void loadPropertiesFile(String propertiesFileName) {
        properties = new Properties();
        InputStream scmsStream = null;
        try {
            scmsStream = PropertiesUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);
            properties.load(scmsStream);
        }
        catch (Exception e) {
            logger.error("\u914d\u7f6e\u6587\u4ef6[{}]\u4e0d\u5b58\u5728\u3002", (Object)propertiesFileName, (Object)e);
        }
        finally {
            try {
                if (scmsStream != null) {
                    scmsStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u914d\u7f6e\u6587\u4ef6[{}]\u5173\u95ed\u5f02\u5e38", (Object)propertiesFileName, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperties(String propertiesName, String key) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = PropertiesUtils.class.getClassLoader().getResourceAsStream(propertiesName);
            props.load(inputStream);
        }
        catch (IOException e) {
            logger.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u914d\u7f6e\u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key) {
        String result = properties.getProperty(key);
        return result;
    }

    public static String getProperty(String key, String defaultValue) {
        String result = properties.getProperty(key, defaultValue);
        return result;
    }

    public static Object getObject(String key, Class clazz) {
        String obj = PropertiesUtils.getProperty(key);
        return TypeUtils.castToJavaBean((Object)obj, (Class)clazz);
    }

    public static Boolean getBoolean(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToBoolean((Object)value);
    }

    public static byte[] getBytes(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToBytes((Object)value);
    }

    public static boolean getBooleanValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToBoolean((Object)value);
    }

    public static Byte getByte(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToByte((Object)value);
    }

    public static byte getByteValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToByte((Object)value);
    }

    public static Short getShort(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToShort((Object)value);
    }

    public static short getShortValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToShort((Object)value);
    }

    public static Integer getInteger(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToInt((Object)value);
    }

    public static int getIntValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToInt((Object)value);
    }

    public static Long getLong(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToLong((Object)value);
    }

    public static long getLongValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToLong((Object)value);
    }

    public static Float getFloat(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToFloat((Object)value);
    }

    public static float getFloatValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToFloat((Object)value).floatValue();
    }

    public static Double getDouble(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToDouble((Object)value);
    }

    public static double getDoubleValue(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToDouble((Object)value);
    }

    public static BigDecimal getBigDecimal(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToBigDecimal((Object)value);
    }

    public static BigInteger getBigInteger(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToBigInteger((Object)value);
    }

    public static String getString(String key) {
        String value = PropertiesUtils.getProperty(key);
        return value.toString();
    }

    public static Date getDate(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToDate((Object)value);
    }

    public static java.sql.Date getSqlDate(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToSqlDate((Object)value);
    }

    public static Timestamp getTimestamp(String key) {
        String value = PropertiesUtils.getProperty(key);
        return TypeUtils.castToTimestamp((Object)value);
    }
}

