/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.xdja.pki.backup.common.ErrorEnum;
import com.xdja.pki.backup.common.PageInfo;
import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.dao.BackupConfigDao;
import com.xdja.pki.backup.dao.BackupDao;
import com.xdja.pki.backup.dao.model.BackupConfigDO;
import com.xdja.pki.backup.dao.model.BackupDO;
import com.xdja.pki.backup.dao.model.EachFileHashDo;
import com.xdja.pki.backup.dao.model.FileHashDO;
import com.xdja.pki.backup.service.manager.BackupService;
import com.xdja.pki.backup.service.manager.DatabaseBackupOperateHelper;
import com.xdja.pki.backup.service.manager.bean.BackupReq;
import com.xdja.pki.backup.service.manager.bean.BackupVO;
import com.xdja.pki.backup.util.BackupFileUtils;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.backup.util.DataSourceUtils;
import com.xdja.pki.backup.util.DateUtils;
import com.xdja.pki.backup.util.FileUtils;
import com.xdja.pki.backup.util.JsonUtils;
import com.xdja.pki.backup.util.ZipUtils;
import com.xdja.pki.dynamic.task.CronTaskRegistrar;
import com.xdja.pki.dynamic.task.SchedulingRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupServiceImpl
implements BackupService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DataSourceUtils dataSourceUtils;
    @Autowired
    BackupDao backupDao;
    @Autowired
    BackupConfigDao backupConfigDao;
    @Autowired
    DatabaseBackupOperateHelper databaseBackupOperateHelper;
    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;

    @Override
    public void autoTotalBackup() {
        this.totalBackup(null, 0);
    }

    @Override
    public void autoIncBackup() {
        this.appendBackup(null, 0);
    }

    @Override
    public void artificialTotalBackup() {
        try {
            String beanString = System.getProperty("system_property_key_backup_artificial_total");
            BackupReq backupReq = JsonUtils.json2Object(beanString, BackupReq.class);
            this.totalBackup(backupReq, 1);
        }
        finally {
            System.clearProperty("system_property_key_backup_artificial_total");
        }
    }

    @Override
    public void artificialIncBackup() {
        try {
            String beanString = System.getProperty("system_property_key_backup_artificial_inc");
            BackupReq backupReq = JsonUtils.json2Object(beanString, BackupReq.class);
            this.appendBackup(backupReq, 1);
        }
        finally {
            System.clearProperty("system_property_key_backup_artificial_inc");
        }
    }

    @Override
    public Result downloadBackupFile(String id) {
        BackupDO backupDO;
        Result result = new Result();
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            backupDO = this.backupDao.getBackupById(Long.valueOf(id));
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u5931\u8d25\uff1a\u5907\u4efd\u8bb0\u5f55[{}]\u4e0d\u5b58\u5728", (Object)id, (Object)e);
            result.setError(ErrorEnum.BACKUP_DOWNLOAD_NO_SUCH_RECORD);
            return result;
        }
        if (1 == backupDO.getBackupStatus()) {
            byte[] bytes;
            info.put("backupDO", backupDO);
            try {
                bytes = FileUtils.readByBinary(backupDO.getBackupFilePath());
            }
            catch (IOException e) {
                this.logger.error("\u4e0b\u8f7d\u5931\u8d25\uff1a\u5907\u4efd\u6587\u4ef6[{}]\u4e0d\u5b58\u5728", (Object)backupDO.getBackupFilePath());
                result.setError(ErrorEnum.BACKUP_DOWNLOAD_NO_SUCH_FILE);
                return result;
            }
            info.put("zipFileByte", bytes);
            return Result.success(info);
        }
        this.logger.error("\u4e0b\u8f7d\u5931\u8d25\uff1a\u5907\u4efd\u6587\u4ef6[{}]\u4e0d\u53ef\u7528,\u72b6\u6001[{}]", (Object)id, (Object)backupDO.getBackupStatus());
        result.setError(ErrorEnum.BACKUP_DOWNLOAD_ERROR_FILE);
        return result;
    }

    @Override
    public Result goBackup(BackupReq backupReq) {
        String curentDateStr = DateUtils.plusSecond(2, "yyyy-MM-dd HH:mm:ss");
        String currentDateCron = DateUtils.getCron6(DateUtils.strToDate(curentDateStr));
        if (0 == backupReq.getBackupType()) {
            System.setProperty("system_property_key_backup_artificial_total", JsonUtils.object2Json(backupReq));
            this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[artificialTotalBackup()] crn[{}]", (Object)currentDateCron);
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "artificialTotalBackup"), currentDateCron);
            return Result.success();
        }
        System.setProperty("system_property_key_backup_artificial_inc", JsonUtils.object2Json(backupReq));
        this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[artificialIncBackup()] crn[{}]", (Object)currentDateCron);
        this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "artificialIncBackup"), currentDateCron);
        return Result.success();
    }

    @Override
    public Result getTotalBackupByPage(int pageNo, int pageSize) {
        Result result = new Result();
        ArrayList<BackupVO> backupVOList = new ArrayList<BackupVO>();
        PageInfo<BackupDO> doPageInfo = this.backupDao.getTotalBackupByPage(pageNo, pageSize);
        List<BackupDO> backupDOList = doPageInfo.getList();
        if (backupDOList != null && backupDOList.size() > 0) {
            for (BackupDO backupDO : backupDOList) {
                BackupVO backupVO = new BackupVO();
                BeanUtils.copyProperties((Object)backupDO, (Object)backupVO);
                backupVO.setGmtCreate(DateUtils.dateToString(backupDO.getGmtCreate(), "yyyy-MM-dd HH:mm:ss"));
                backupVO.setGmtModified(DateUtils.dateToString(backupDO.getGmtModified(), "yyyy-MM-dd HH:mm:ss"));
                backupVOList.add(backupVO);
            }
        }
        PageInfo<BackupVO> voPageInfo = new PageInfo<BackupVO>(pageNo, pageSize, doPageInfo.getRecordCount());
        voPageInfo.setList(backupVOList);
        result.setInfo(voPageInfo);
        return result;
    }

    @Override
    public Result getIncBackupByPage(Long parentId) {
        Result result = new Result();
        ArrayList<BackupVO> backupVOList = new ArrayList<BackupVO>();
        List<BackupDO> backupDOList = this.backupDao.getBackupByParentId(parentId);
        if (backupDOList != null && backupDOList.size() > 0) {
            for (BackupDO backupDO : backupDOList) {
                BackupVO backupVO = new BackupVO();
                BeanUtils.copyProperties((Object)backupDO, (Object)backupVO);
                backupVO.setGmtCreate(DateUtils.dateToString(backupDO.getGmtCreate(), "yyyy-MM-dd HH:mm:ss"));
                backupVO.setGmtModified(DateUtils.dateToString(backupDO.getGmtModified(), "yyyy-MM-dd HH:mm:ss"));
                backupVOList.add(backupVO);
            }
        }
        result.setInfo(backupVOList);
        return result;
    }

    @Override
    public void autoCleanOverdueBackup() {
        String currentTime = DateUtils.getCurrentTime("yyyyMMddHHmmss");
        this.logger.info("autoCleanOverdueBackup()[{}] startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        Integer fileRetention = this.backupConfigDao.getBackupConfig().getFileRetentionPeriod();
        if (fileRetention == null) {
            this.logger.error("autoCleanOverdueBackup()[{}] \u672a\u8bbe\u7f6e\u6587\u4ef6\u4fdd\u7559\u671f", (Object)currentTime);
            return;
        }
        String expiredDateStr = DateUtils.plusDay(-(fileRetention * 30), "yyyy-MM-dd") + " 00:00:00";
        List<BackupDO> backupDOList = this.backupDao.getExpireBackupListBefore(expiredDateStr);
        if (backupDOList != null && backupDOList.size() > 0) {
            for (BackupDO backupDO : backupDOList) {
                FileUtils.deleteFile(backupDO.getBackupFilePath());
                backupDO.setFileExpired(1);
                this.backupDao.update(backupDO);
            }
        }
        this.logger.info("autoCleanOverdueBackup()[{}] end[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
    }

    @Override
    public Result exitBackupOperate(Integer backupType) {
        Result result = new Result();
        boolean noExit = 0 == backupType ? System.getProperty("system_property_key_backup_artificial_total") == null : System.getProperty("system_property_key_backup_artificial_inc") == null;
        result.setInfo(noExit ? 0 : 1);
        return result;
    }

    @Override
    public int cleanErrorBackup() {
        return this.backupDao.updateBackuping();
    }

    private Result totalBackup(BackupReq backupReq, Integer backupMode) {
        Result result = new Result();
        String currentTime = DateUtils.getCurrentTime("yyyyMMddHHmmss");
        this.logger.info("totalBackup()[{}] startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        String ramark = backupReq == null ? null : backupReq.getRemark();
        String backupDirEndName = backupReq == null ? "_total_auto" : "_total_artificial";
        List<BackupDO> backupDOList = this.backupDao.getBackupList(backupMode, 0, 0);
        for (BackupDO backupDO1 : backupDOList) {
            backupDO1.setBackupStatus(2);
            backupDO1.setGmtModified(new Date());
            backupDO1.setFailMsg("\u5907\u4efd\u5931\u8d25\uff01\u81ea\u52a8\u5173\u95ed\u3002");
            this.backupDao.update(backupDO1);
            this.logger.error("totalBackup()[{}] \u81ea\u52a8\u5173\u95ed\u4e4b\u524d\u7684\u5907\u4efd", (Object)currentTime);
        }
        BackupDO backupDO = new BackupDO();
        backupDO.setGmtModified(new Date());
        backupDO.setGmtCreate(new Date());
        backupDO.setBackupStatus(0);
        backupDO.setBackupType(0);
        backupDO.setBackupMode(backupMode);
        backupDO.setRemark(ramark);
        backupDO = this.backupDao.insertBackup(backupDO);
        BackupConfigDO backupConfigDO = this.backupConfigDao.getBackupConfig();
        String backupTargetPath = backupConfigDO.getBackupPath() + "/" + currentTime + backupDirEndName;
        this.logger.info("totalBackup()[{}] \u672c\u6b21\u5907\u4efd\u76ee\u5f55[{}]", (Object)currentTime, (Object)backupConfigDO);
        String sqlDirPath = backupTargetPath + "/" + ConfigUtils.getZipSqlPath();
        try {
            FileUtils.mkdirs(sqlDirPath);
            String sqlFile = sqlDirPath + "/data.sql";
            this.logger.info("totalBackup()[{}] \u5907\u4efd\u6570\u636e\u5e93\u5e93 startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            this.databaseBackupOperateHelper.goBackup(sqlFile);
        }
        catch (Exception e) {
            this.logger.error("totalBackup()[{}] \u5907\u4efd\u6570\u636e\u5e93\u5f02\u5e38\uff1a{}", new Object[]{currentTime, DateUtils.getCurrentTime(), e});
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_MYSQL_DUMP_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_MYSQL_DUMP_ERROR);
            return result;
        }
        this.logger.info("totalBackup()[{}] \u5907\u4efd\u6570\u636e\u5e93\u5e93 endTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        EachFileHashDo eachFileHashList = BackupFileUtils.scanFile();
        String tomcatConfPath = backupTargetPath + "/" + ConfigUtils.getZipTomcatConfPath();
        String sysConfPath = backupTargetPath + "/" + ConfigUtils.getZipSysConfPath();
        String sancHsmConfPath = backupTargetPath + "/" + ConfigUtils.getZipSancHsmConfPath();
        String yunHsmConfPath = backupTargetPath + "/" + ConfigUtils.getZipYunHsmConfPath();
        try {
            this.logger.info("totalBackup()[{}] \u590d\u5236Tomcat\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, tomcatConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(ConfigUtils.getTomcatConfPath(), tomcatConfPath);
            this.logger.info("totalBackup()[{}] \u590d\u5236\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, sysConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(ConfigUtils.getSysConfPath(), sysConfPath);
            this.logger.info("totalBackup()[{}] \u590d\u5236\u4e09\u672a\u4fe1\u5b89\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, sancHsmConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(ConfigUtils.getSancHsmConfPath(), sancHsmConfPath);
            this.logger.info("totalBackup()[{}] \u590d\u5236\u4e91\u5bc6\u7801\u673a\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, yunHsmConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(ConfigUtils.getYunHsmConfPath(), yunHsmConfPath);
        }
        catch (Exception e) {
            this.logger.error("totalBackup()[{}] \u590d\u5236\u914d\u7f6e\u6587\u4ef6\u5931\u8d25[{}] ", (Object)currentTime, (Object)e);
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_FILE_COPY_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_FILE_COPY_ERROR);
            return result;
        }
        String finallZipFileName = backupTargetPath + ".zip";
        String fileZipFileName = ConfigUtils.getKeyBackupFile();
        String sqlZipFileName = ConfigUtils.getKeySqlFileKey();
        HashMap<String, String> backupFileHasJsonDo = new HashMap<String, String>();
        try {
            this.logger.info("totalBackup()[{}] \u914d\u7f6e\u6587\u4ef6\u6253\u5305 startTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(tomcatConfPath);
            fileNames.add(sysConfPath);
            fileNames.add(sancHsmConfPath);
            fileNames.add(yunHsmConfPath);
            ZipUtils.compress(fileNames, backupTargetPath + "/" + fileZipFileName);
            ZipUtils.compress(sqlDirPath, backupTargetPath + "/" + sqlZipFileName, true);
            this.logger.info("totalBackup()[{}] \u5220\u9664\u5907\u4efd\u4e34\u65f6\u76ee\u5f55 startTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            fileNames.add(sqlDirPath);
            FileUtils.deleteFiles(fileNames);
            this.logger.info("totalBackup()[{}] \u751f\u6210Hash\u6587\u4ef6[backupConfig.json] startTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            List<FileHashDO> fileHashDOList = BackupFileUtils.scanFile(backupTargetPath);
            for (FileHashDO fileHashDo : fileHashDOList) {
                backupFileHasJsonDo.put(fileHashDo.getFileName(), fileHashDo.getFileHash());
            }
            FileUtils.saveFile(JsonUtils.object2Json(backupFileHasJsonDo), backupTargetPath + "/" + ConfigUtils.getBackupFileHashJsonFile());
            ZipUtils.compress(backupTargetPath, finallZipFileName, true);
            FileUtils.deleteFile(backupTargetPath);
        }
        catch (Exception e) {
            this.logger.error("totalBackup()[{}] \u6587\u4ef6\u6253\u5305\u5931\u8d25[{}] ", (Object)currentTime, (Object)e);
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_FILE_PACKAGE_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_FILE_PACKAGE_ERROR);
            return result;
        }
        BackupDO tmp = this.backupDao.getBackupById(backupDO.getId());
        if (tmp != null && tmp.getBackupStatus().equals(0)) {
            File finallZipFile = new File(finallZipFileName);
            backupDO.setBackupName(finallZipFile.getName());
            backupDO.setBackupFilePath(finallZipFileName);
            backupDO.setBackupFileSize((double)finallZipFile.length() / 1048576.0);
            backupDO.setConfigFileHash((String)backupFileHasJsonDo.get(fileZipFileName));
            backupDO.setSqlFileHash((String)backupFileHasJsonDo.get(sqlZipFileName));
            backupDO.setEachConfigFileHash(JsonUtils.object2Json(eachFileHashList));
            backupDO.setBackupStatus(1);
            backupDO.setFileExpired(0);
            backupDO.setGmtModified(new Date());
            int i = this.backupDao.update(backupDO);
            if (i == 0) {
                this.logger.error("totalBackup()[{}] \u5907\u4efd\u5931\u8d25[{}]\uff1a\u672a\u77e5\u539f\u56e0\uff0cendTime[{}}]...", new Object[]{currentTime, backupDO.getId(), DateUtils.getCurrentTime()});
                result.setError(ErrorEnum.BACKUP_SAVE_RECORD_ERROR);
                return result;
            }
        } else {
            this.logger.error("totalBackup()[{}] \u66f4\u65b0\u5931\u8d25[{}\u72b6\u6001\u5df2\u8fc7\u671f]...", (Object)currentTime, (Object)backupDO.getId());
            result.setError(ErrorEnum.BACKUP_RECORD_STATUS_ERROR);
            return result;
        }
        this.logger.info("totalBackup()[{}] \u5907\u4efd\u5b8c\u6210[{}]\uff0cendTime[{}}]...", new Object[]{currentTime, backupDO.getId(), DateUtils.getCurrentTime()});
        return result;
    }

    private Result appendBackup(BackupReq backupReq, Integer backupMode) {
        Result result = new Result();
        String currentTime = DateUtils.getCurrentTime("yyyyMMddHHmmss");
        this.logger.info("incBackup() [{}] startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        String ramark = backupReq == null ? null : backupReq.getRemark();
        String backupDirEndName = backupReq == null ? "_increment_auto" : "_increment_artificial";
        BackupDO totalBackupDO = this.backupDao.getLastTotalBackup(backupMode);
        if (totalBackupDO == null) {
            this.logger.info("incBackup() [{}] \u5907\u4efd\u5931\u8d25:\u4e0d\u5b58\u5728\u5168\u91cf\u5907\u4efd", (Object)currentTime);
            result.setError(ErrorEnum.INC_BACKUP_NO_FULL_BACKUP_ERROR);
            return result;
        }
        List<BackupDO> backupDOList = this.backupDao.getBackupList(backupMode, 1, 0);
        for (BackupDO backupDO1 : backupDOList) {
            backupDO1.setBackupStatus(2);
            backupDO1.setGmtModified(new Date());
            backupDO1.setFailMsg("\u5907\u4efd\u5931\u8d25\uff01\u81ea\u52a8\u5173\u95ed\u3002");
            this.backupDao.update(backupDO1);
            this.logger.error("incBackup() [{}] \u81ea\u52a8\u5173\u95ed\u4e4b\u524d\u7684\u5907\u4efd", (Object)currentTime);
        }
        BackupDO backupDO = new BackupDO();
        backupDO.setParentId(totalBackupDO.getId());
        backupDO.setGmtModified(new Date());
        backupDO.setGmtCreate(new Date());
        backupDO.setBackupStatus(0);
        backupDO.setBackupType(1);
        backupDO.setBackupMode(backupMode);
        switch (totalBackupDO.getBackupStatus()) {
            case 0: {
                backupDO.setFailMsg(ErrorEnum.INC_BACKUP_FULL_BACKUP_ING.desc);
                this.backupDao.insertBackup(backupDO);
                result.setError(ErrorEnum.INC_BACKUP_FULL_BACKUP_ING);
                return result;
            }
            case 2: {
                backupDO.setFailMsg(ErrorEnum.INC_BACKUP_FULL_BACKUP_ERROR.desc);
                this.backupDao.insertBackup(backupDO);
                result.setError(ErrorEnum.INC_BACKUP_FULL_BACKUP_ERROR);
                return result;
            }
        }
        backupDO.setRemark(ramark);
        backupDO = this.backupDao.insertBackup(backupDO);
        BackupConfigDO backupConfigDO = this.backupConfigDao.getBackupConfig();
        String backupTargetPath = backupConfigDO.getBackupPath() + "/" + currentTime + backupDirEndName;
        this.logger.info("incBackup() [{}] \u672c\u6b21\u5907\u4efd\u76ee\u5f55[{}]", (Object)currentTime, (Object)backupTargetPath);
        String sqlDirPath = backupTargetPath + "/" + ConfigUtils.getZipSqlPath();
        try {
            FileUtils.mkdirs(sqlDirPath);
            String sqlFile = sqlDirPath + "/data.sql";
            this.logger.info("incBackup() [{}] \u5907\u4efd\u6570\u636e\u5e93\u5e93 startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            this.databaseBackupOperateHelper.goBackup(sqlFile);
        }
        catch (Exception e) {
            this.logger.error("incBackup() [{}] \u6570\u636e\u5e93\u5907\u4efd\u5f02\u5e38\uff1a{}", new Object[]{currentTime, DateUtils.getCurrentTime(), e});
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_MYSQL_DUMP_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_MYSQL_DUMP_ERROR);
            return result;
        }
        this.logger.info("incBackup() [{}] \u5907\u4efd\u6570\u636e\u5e93\u5e93 endTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        EachFileHashDo totalEachFileHashList = JsonUtils.json2Object(totalBackupDO.getEachConfigFileHash(), EachFileHashDo.class);
        EachFileHashDo newEachFileHashList = BackupFileUtils.scanFile();
        List<FileHashDO> incFileList = BackupFileUtils.compareEachFile(totalEachFileHashList, newEachFileHashList);
        try {
            this.logger.info("incBackup() [{}] \u590d\u5236\u589e\u91cf\u6587\u4ef6\u5230\u4e34\u65f6\u76ee\u5f55[{}] startTime[{}]", new Object[]{currentTime, backupTargetPath, DateUtils.getCurrentTime()});
            BackupFileUtils.copyFiles2BackupPath(incFileList, backupTargetPath + "/");
        }
        catch (IOException e) {
            this.logger.error("incBackup() [{}] \u590d\u5236\u914d\u7f6e\u6587\u4ef6\u5931\u8d25[{}] ", (Object)currentTime, (Object)e);
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_FILE_COPY_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_FILE_COPY_ERROR);
            return result;
        }
        String finallZipFileName = backupTargetPath + ".zip";
        String fileZipFileName = ConfigUtils.getKeyBackupFile();
        String sqlZipFileName = ConfigUtils.getKeySqlFileKey();
        HashMap<String, String> backupFileHasJsonDo = new HashMap<String, String>();
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(backupTargetPath + "/" + ConfigUtils.getZipTomcatConfPath());
            fileNames.add(backupTargetPath + "/" + ConfigUtils.getZipSysConfPath());
            fileNames.add(backupTargetPath + "/" + ConfigUtils.getZipSancHsmConfPath());
            fileNames.add(backupTargetPath + "/" + ConfigUtils.getZipYunHsmConfPath());
            ZipUtils.compress(fileNames, backupTargetPath + "/" + fileZipFileName);
            ZipUtils.compress(sqlDirPath, backupTargetPath + "/" + sqlZipFileName, true);
            this.logger.info("incBackup()[{}] \u5220\u9664\u5907\u4efd\u4e34\u65f6\u76ee\u5f55 startTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            fileNames.add(sqlDirPath);
            FileUtils.deleteFiles(fileNames);
            this.logger.info("incBackup() [{}] \u751f\u6210Hash\u6587\u4ef6[backupConfig.json] startTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
            List<FileHashDO> fileHashDOList = BackupFileUtils.scanFile(backupTargetPath);
            for (FileHashDO fileHashDo : fileHashDOList) {
                backupFileHasJsonDo.put(fileHashDo.getFileName(), fileHashDo.getFileHash());
            }
            backupFileHasJsonDo.put(ConfigUtils.getKeyTotalZipFileName(), totalBackupDO.getBackupName());
            FileUtils.saveFile(JsonUtils.object2Json(backupFileHasJsonDo), backupTargetPath + "/" + ConfigUtils.getBackupFileHashJsonFile());
            ZipUtils.compress(backupTargetPath, finallZipFileName, true);
            FileUtils.deleteFile(backupTargetPath);
        }
        catch (Exception e) {
            this.logger.error("incBackup() [{}] \u6587\u4ef6\u6253\u5305\u5931\u8d25[{}] ", (Object)currentTime, (Object)e);
            backupDO.setBackupStatus(2);
            backupDO.setGmtModified(new Date());
            backupDO.setFailMsg(ErrorEnum.BACKUP_FILE_PACKAGE_ERROR.desc);
            this.backupDao.update(backupDO);
            result.setError(ErrorEnum.BACKUP_FILE_PACKAGE_ERROR);
            return result;
        }
        BackupDO tmp = this.backupDao.getBackupById(backupDO.getId());
        if (tmp != null && tmp.getBackupStatus().equals(0)) {
            File finallZipFile = new File(finallZipFileName);
            backupDO.setBackupName(finallZipFile.getName());
            backupDO.setBackupFilePath(finallZipFileName);
            backupDO.setBackupFileSize((double)finallZipFile.length() / 1048576.0);
            backupDO.setConfigFileHash((String)backupFileHasJsonDo.get(fileZipFileName));
            backupDO.setSqlFileHash((String)backupFileHasJsonDo.get(sqlZipFileName));
            backupDO.setEachConfigFileHash(JsonUtils.object2Json(incFileList));
            backupDO.setBackupStatus(1);
            backupDO.setFileExpired(0);
            backupDO.setGmtModified(new Date());
            int i = this.backupDao.update(backupDO);
            if (i == 0) {
                this.logger.error("incBackup() [{}] \u5907\u4efd\u5931\u8d25\uff1a\u672a\u77e5\u539f\u56e0\uff0cbackupId[{}]\uff0cendTime[{}}]...", new Object[]{currentTime, backupDO.getId(), DateUtils.getCurrentTime()});
                result.setError(ErrorEnum.BACKUP_SAVE_RECORD_ERROR);
                return result;
            }
        } else {
            this.logger.error("incBackup() [{}] \u66f4\u65b0\u5931\u8d25[{}\u72b6\u6001\u5df2\u8fc7\u671f]...", (Object)currentTime, (Object)backupDO.getId());
            result.setError(ErrorEnum.BACKUP_RECORD_STATUS_ERROR);
            return result;
        }
        this.logger.info("incBackup() [{}] \u5907\u4efd\u5b8c\u6210\uff0cbackupId[{}]\uff0cendTime[{}}]...", new Object[]{currentTime, backupDO.getId(), DateUtils.getCurrentTime()});
        return result;
    }
}

