/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.backup.common.ErrorEnum;
import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.dao.BackupConfigDao;
import com.xdja.pki.backup.dao.model.BackupConfigDO;
import com.xdja.pki.backup.service.manager.DatabaseBackupOperateHelper;
import com.xdja.pki.backup.service.manager.RecoveryService;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.backup.util.DateUtils;
import com.xdja.pki.backup.util.FileUtils;
import com.xdja.pki.backup.util.ServerXmlUtils;
import com.xdja.pki.backup.util.ZipUtils;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RecoveryServiceImpl
implements RecoveryService {
    private Logger logger = LoggerFactory.getLogger(RecoveryServiceImpl.class);
    @Autowired
    BackupConfigDao backupConfigDao;
    @Autowired
    DatabaseBackupOperateHelper databaseBackupOperateHelper;

    @Override
    public Result recovery(MultipartFile totalFileData, MultipartFile incFileData) {
        Result result = new Result();
        ConfigUtils.setRecoveryStatus(0);
        String currentTime = DateUtils.getCurrentDate("yyyyMMddHHmm");
        this.logger.info("recovery() [{}] startTime[{}]...", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        boolean hasInc = incFileData != null;
        BackupConfigDO backupConfigDO = this.backupConfigDao.getBackupConfig();
        String recoverTargetPath = backupConfigDO.getRecoverPath() + "/" + currentTime;
        this.logger.info("recovery() [{}] \u672c\u6b21\u6062\u590d\u76ee\u5f55[{}]", (Object)currentTime, (Object)recoverTargetPath);
        FileUtils.mkdirs(recoverTargetPath);
        String totalRecoveryFileFullName = totalFileData.getOriginalFilename();
        int index = totalRecoveryFileFullName.lastIndexOf("\\");
        if (index > 0) {
            totalRecoveryFileFullName = totalRecoveryFileFullName.substring(index + 1);
        }
        String totalRecoveryDirName = totalRecoveryFileFullName.substring(0, totalRecoveryFileFullName.lastIndexOf("."));
        String incRecoveryFileFullName = null;
        String incRecoverDirName = null;
        if (hasInc) {
            incRecoveryFileFullName = incFileData.getOriginalFilename();
            index = incRecoveryFileFullName.lastIndexOf("\\");
            if (index > 0) {
                incRecoveryFileFullName = incRecoveryFileFullName.substring(index + 1);
            }
            incRecoverDirName = incRecoveryFileFullName.substring(0, incRecoveryFileFullName.lastIndexOf("."));
        }
        if (hasInc) {
            try {
                incFileData.transferTo(new File(recoverTargetPath + "/" + incRecoveryFileFullName));
                ZipUtils.uncompress(recoverTargetPath + "/" + incRecoveryFileFullName, recoverTargetPath);
            }
            catch (Exception e) {
                this.logger.info("recovery() \u4fdd\u5b58\u5168\u91cf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                ConfigUtils.setRecoveryStatus(2);
                result.setError(ErrorEnum.RECOVER_SAVE_FULL_BACKUP_FILE_ERROR);
                return result;
            }
            try {
                String backupFileHashJsonFileName = recoverTargetPath + "/" + incRecoverDirName + "/" + ConfigUtils.getBackupFileHashJsonFile();
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.read(backupFileHashJsonFileName));
                String totalZipFileName = (String)jsonObject.get((Object)ConfigUtils.getKeyTotalZipFileName());
                if (totalZipFileName == null) {
                    this.logger.info("recovery() [{}] \u5907\u4efd\u5931\u8d25\uff1a\u589e\u91cf\u5907\u4efd\u6587\u4ef6[{}]\u683c\u5f0f\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5168\u91cf\u5907\u4efd\u6587\u4ef6\u540d", (Object)currentTime, (Object)incRecoveryFileFullName);
                    ConfigUtils.setRecoveryStatus(2);
                    result.setError(ErrorEnum.RECOVER_INC_BACKUP_FILE_STRUCTURE_ERROR);
                    return result;
                }
                if (!totalZipFileName.equals(totalRecoveryFileFullName)) {
                    this.logger.info("recovery()  [{}] \u5907\u4efd\u5931\u8d25\uff1a\u5168\u91cf\u548c\u589e\u91cf\u6587\u4ef6\u4e0d\u5339\u914d\uff0c\u671f\u5f85\u6587\u4ef6\u540d[{}]<>\u5b9e\u9645\u6587\u4ef6\u540d[{}]", new Object[]{currentTime, totalZipFileName, totalRecoveryFileFullName});
                    ConfigUtils.setRecoveryStatus(2);
                    result.setError(ErrorEnum.RECOVER_BACKUP_FILE_MISSMATCHING);
                    return result;
                }
                String sqlZipFileName = null;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    if (entry.getKey().toString().lastIndexOf(".sql.zip") <= 0) continue;
                    sqlZipFileName = entry.getKey().toString();
                    break;
                }
                ZipUtils.uncompress(recoverTargetPath + "/" + incRecoverDirName + "/" + sqlZipFileName, recoverTargetPath);
            }
            catch (Exception e) {
                this.logger.info("recovery() [{}] \u589e\u91cf\u6587\u4ef6\u89e3\u538b\u5931\u8d25", (Object)currentTime, (Object)e);
                ConfigUtils.setRecoveryStatus(2);
                result.setError(ErrorEnum.RECOVER_INC_FILE_UNCOMPRESS_EXCEPTION);
                return result;
            }
        }
        String fileConfigDirName = ConfigUtils.getKeyBackupFile();
        try {
            totalFileData.transferTo(new File(recoverTargetPath + "/" + totalRecoveryFileFullName));
            ZipUtils.uncompress(recoverTargetPath + "/" + totalRecoveryFileFullName, recoverTargetPath);
            if (!hasInc) {
                String sqlZipFileName = null;
                String backupFileHashJsonFileName = recoverTargetPath + "/" + totalRecoveryDirName + "/" + ConfigUtils.getBackupFileHashJsonFile();
                JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.read(backupFileHashJsonFileName));
                for (Map.Entry entry : jsonObject.entrySet()) {
                    if (entry.getKey().toString().lastIndexOf(".sql.zip") <= 0) continue;
                    sqlZipFileName = entry.getKey().toString();
                    break;
                }
                ZipUtils.uncompress(recoverTargetPath + "/" + totalRecoveryDirName + "/" + sqlZipFileName, recoverTargetPath);
            }
        }
        catch (Exception e) {
            this.logger.info("recovery() [{}] \u5168\u91cf\u6587\u4ef6\u89e3\u538b\u5931\u8d25", (Object)currentTime, (Object)e);
            ConfigUtils.setRecoveryStatus(2);
            result.setError(ErrorEnum.RECOVER_FULL_FILE_UNCOMPRESS_EXCEPTION);
            return result;
        }
        try {
            this.logger.info("recovery() [{}]  \u89e3\u538b\u5168\u91cf\u914d\u7f6e\u6587\u4ef6", (Object)currentTime);
            ZipUtils.uncompress(recoverTargetPath + "/" + totalRecoveryDirName + "/" + fileConfigDirName, recoverTargetPath);
            if (hasInc) {
                this.logger.info("recovery() [{}]  \u89e3\u538b\u589e\u91cf\u914d\u7f6e\u6587\u4ef6", (Object)currentTime);
                ZipUtils.uncompress(recoverTargetPath + "/" + incRecoverDirName + "/" + fileConfigDirName, recoverTargetPath);
            }
        }
        catch (Exception e) {
            this.logger.info("recovery() \u914d\u7f6e\u6587\u4ef6\u5408\u5e76\u5931\u8d25", (Throwable)e);
            ConfigUtils.setRecoveryStatus(2);
            result.setError(ErrorEnum.RECOVER_FILE_MERGE_EXCEPTION);
            return result;
        }
        String tomcatConfPath = recoverTargetPath + "/" + ConfigUtils.getZipTomcatConfPath();
        try {
            ServerXmlUtils.loadServerXml(tomcatConfPath + "/server.xml");
            String tomcatHttpsPort = ServerXmlUtils.getAnHTTPSPort();
            this.logger.info("recovery() [{}] tomcatHttpsPort[{}]", (Object)currentTime, (Object)tomcatHttpsPort);
            if (tomcatHttpsPort == null) {
                this.logger.error("recovery() [{}] \u7cfb\u7edf\u6062\u590d\u5931\u8d25:Tomcat\u7684HTTPS\u7aef\u53e3\u53f7\u4e0d\u5b58\u5728. currentTime[{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
                ConfigUtils.setRecoveryStatus(2);
                result.setError(ErrorEnum.RECOVER_TOMCAT_HTTPS_PORT_NO_EXIT_EXCEPTION);
                return result;
            }
            result.setInfo(tomcatHttpsPort);
        }
        catch (Exception e) {
            this.logger.error("recovery() [{}] currentTime[{}] \u8fd8\u539f\u6570\u636e\u5e93\u5f02\u5e38\uff1atomcat\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38. ", new Object[]{currentTime, DateUtils.getCurrentTime(), e});
            ConfigUtils.setRecoveryStatus(2);
            result.setError(ErrorEnum.RECOVER_TOMCAT_SERVER_XML_ERROR);
            return result;
        }
        try {
            String sqlDirPath = recoverTargetPath + "/" + ConfigUtils.getZipSqlPath();
            String sqlFile = sqlDirPath + "/data.sql";
            this.databaseBackupOperateHelper.goRecover(sqlFile);
        }
        catch (Exception e) {
            this.logger.error("recovery() [{}] \u8fd8\u539f\u6570\u636e\u5e93\u5f02\u5e38\uff1a{}", new Object[]{currentTime, DateUtils.getCurrentTime(), e});
            ConfigUtils.setRecoveryStatus(2);
            result.setError(ErrorEnum.RECOVER_MYSQL_DATABASE_ERROR);
            return result;
        }
        String sysConfPath = recoverTargetPath + "/" + ConfigUtils.getZipSysConfPath();
        String sancHsmConfPath = recoverTargetPath + "/" + ConfigUtils.getZipSancHsmConfPath();
        String yunHsmConfPath = recoverTargetPath + "/" + ConfigUtils.getZipYunHsmConfPath();
        try {
            this.logger.info("recovery() [{}] \u8fd8\u539f\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, sysConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(sysConfPath, ConfigUtils.getSysConfPath());
            this.logger.info("recovery() [{}] \u8fd8\u539f\u4e09\u672a\u4fe1\u5b89\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, sancHsmConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(sancHsmConfPath, ConfigUtils.getSancHsmConfPath());
            this.logger.info("recovery() [{}] \u8fd8\u539f\u4e91\u5bc6\u7801\u673a\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, yunHsmConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(yunHsmConfPath, ConfigUtils.getYunHsmConfPath());
            this.logger.info("recovery() [{}] \u8fd8\u539fTomcat\u914d\u7f6e\u6587\u4ef6[{}] startTime[{}]", new Object[]{currentTime, tomcatConfPath, DateUtils.getCurrentTime()});
            FileUtils.copyDir(tomcatConfPath, ConfigUtils.getTomcatConfPath());
        }
        catch (Exception e) {
            this.logger.error("recovery() [{}] \u8fd8\u539f\u914d\u7f6e\u6587\u4ef6\u5931\u8d25[{}] ", (Object)currentTime, (Object)e);
            ConfigUtils.setRecoveryStatus(2);
            result.setError(ErrorEnum.RECOVER_CONFIG_FILE_ERROR);
            return result;
        }
        this.logger.info("recovery() [{}] \u7cfb\u7edf\u6062\u590d\u5b8c\u6210\uff01 [{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
        ConfigUtils.setRecoveryStatus(2);
        this.restartTomcat(currentTime);
        return result;
    }

    private void restartTomcat(String currentTime) {
        try {
            String path = System.getProperty("catalina.home");
            new Thread(() -> {
                try {
                    Thread.sleep(900L);
                    Runtime.getRuntime().exec(path + "/bin/restart.sh");
                }
                catch (Exception e) {
                    this.logger.info("recovery() [{}] \u8bf7\u91cd\u542f\u670d\u52a1 [{}]", (Object)currentTime, (Object)DateUtils.getCurrentTime());
                }
            }).start();
        }
        catch (Exception e) {
            throw new RuntimeException("\u91cd\u542ftomcat\u5931\u8d25", e);
        }
    }

    @Override
    public Result isRecoveryOver() {
        if (ConfigUtils.getRecoveryStatus() == null) {
            return Result.failure(ErrorEnum.RECOVER_STATUS_NO_SUCH_OPERATE);
        }
        switch (ConfigUtils.getRecoveryStatus()) {
            case 0: {
                return Result.success("\u5907\u4efd\u4e2d");
            }
            case 1: {
                return Result.success("\u5907\u4efd\u6210\u529f");
            }
            case 2: {
                return Result.failure(ErrorEnum.RECOVER_STATUS_FAIL);
            }
        }
        return Result.failure(ErrorEnum.RECOVER_STATUS_UNKNOWN);
    }
}

