/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);
    private static final int BUFFER_SIZE = 2048;

    public static void compress(String sourceFileName, String targetFileName, boolean keepDirStructure) throws FileNotFoundException {
        File sourceFile = new File(sourceFileName);
        if (sourceFile.exists()) {
            FileOutputStream fos = new FileOutputStream(new File(targetFileName));
            ZipUtils.compress(sourceFile, fos, keepDirStructure);
        }
    }

    public static void compress(File sourceFile, OutputStream outputStream, boolean keepDirStructure) throws RuntimeException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(outputStream);
            ZipUtils.compress(sourceFile, zipOutputStream, sourceFile.getName(), keepDirStructure);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Exception e) {
                    logger.error("compress \u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    logger.error("compress \u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static void compress(List<String> srcFileNames, String targetFileName) throws FileNotFoundException, RuntimeException {
        ArrayList<File> srcFiles = new ArrayList<File>();
        File sourceFile = null;
        if (srcFileNames != null && srcFileNames.size() > 0) {
            for (String sourceFileName : srcFileNames) {
                sourceFile = new File(sourceFileName);
                if (!sourceFile.exists()) continue;
                srcFiles.add(sourceFile);
            }
            FileOutputStream fos = new FileOutputStream(new File(targetFileName));
            ZipUtils.compress(srcFiles, fos);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("compress \u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static void compress(List<File> srcFiles, OutputStream outputStream) throws RuntimeException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(outputStream);
            for (File srcFile : srcFiles) {
                ZipUtils.compress(srcFile, zos, srcFile.getName(), true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    logger.error("compress \u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("compress \u6587\u4ef6\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(File sourceFile, ZipOutputStream zipOutputStream, String fileName, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            zipOutputStream.putNextEntry(new ZipEntry(fileName));
            FileInputStream in = null;
            try {
                int len;
                in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zipOutputStream.write(buf, 0, len);
                }
            }
            finally {
                zipOutputStream.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null) {
                if (keepDirStructure) {
                    zipOutputStream.putNextEntry(new ZipEntry(fileName + "/"));
                    zipOutputStream.closeEntry();
                }
            } else {
                if (keepDirStructure) {
                    zipOutputStream.putNextEntry(new ZipEntry(fileName + "/"));
                }
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipUtils.compress(file, zipOutputStream, fileName + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    ZipUtils.compress(file, zipOutputStream, file.getName(), keepDirStructure);
                }
                if (keepDirStructure) {
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompress(String inputFile, String destDirPath) throws Exception {
        File srcFile = new File(inputFile);
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try (ZipInputStream zIn = null;){
            zIn = new ZipInputStream(new FileInputStream(srcFile));
            ZipEntry entry = null;
            File file = null;
            while ((entry = zIn.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                file = new File(destDirPath, entry.getName());
                if (!file.exists()) {
                    new File(file.getParent()).mkdirs();
                }
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(out);
                try {
                    int len = -1;
                    byte[] buf = new byte[1024];
                    while ((len = zIn.read(buf)) != -1) {
                        bos.write(buf, 0, len);
                    }
                }
                finally {
                    bos.close();
                    ((OutputStream)out).close();
                }
            }
        }
    }
}

