/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.common;

import com.xdja.pki.backup.common.ErrorBean;
import com.xdja.pki.backup.common.ErrorEnum;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    private int code;
    private Object info;
    private ErrorEnum error;
    private ErrorBean errorBean;
    private String logContent;

    public Result() {
    }

    public Result(int code, Object info) {
        this(code, info, null);
    }

    public Result(int code, Object info, ErrorEnum error) {
        this.code = code;
        this.info = info;
        this.error = error;
        if (null != error) {
            ErrorBean errorBean;
            this.errorBean = errorBean = new ErrorBean(error.code, error.errMsg);
        }
    }

    public String getLogContent() {
        return this.logContent;
    }

    public void setLogContent(String logContent) {
        this.logContent = logContent;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public ErrorEnum getError() {
        return this.error;
    }

    public void setError(ErrorEnum error) {
        ErrorBean errorBean;
        this.code = error.code;
        this.error = error;
        this.errorBean = errorBean = new ErrorBean(error.code, error.errMsg);
    }

    public ErrorBean getErrorBean() {
        return this.errorBean;
    }

    public void setErrorBean(ErrorBean errorBean) {
        this.code = errorBean.getErrCode();
        this.errorBean = errorBean;
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public static Result success(Object info) {
        return new Result(0, info);
    }

    public static Result success() {
        return new Result(0, null);
    }

    public static Result failure(int code) {
        return new Result(code, null);
    }

    public static Result failure(int code, Object info) {
        return new Result(code, info);
    }

    public static Result failure(ErrorEnum error) {
        return new Result(-1, null, error);
    }

    public static Result failure(Object info, ErrorEnum error) {
        return new Result(-1, info, error);
    }

    public ErrorBean resp(HttpServletResponse resp, Result result) {
        resp.setStatus(400);
        if (null == result.getErrorBean()) {
            ErrorBean errorBean = new ErrorBean(result.getError().code, result.getError().errMsg);
            return errorBean;
        }
        return result.getErrorBean();
    }

    public String toString() {
        return "Result{code=" + this.code + ", info=" + this.info + ", error=" + (Object)((Object)this.error) + ", errorBean=" + this.errorBean + ", logContent='" + this.logContent + '\'' + '}';
    }
}

