/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.backup.util.DataSourceUtils;
import com.xdja.pki.backup.util.JsonUtils;
import com.xdja.pki.dao.bean.DatabaseTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabaseBackupOperateHelper {
    private final Logger logger = LoggerFactory.getLogger(DatabaseBackupOperateHelper.class);
    private static final String CACHEL_KEY_INNODB_BUFFER_POOL_SIZE = "innodb_buffer_pool_size";
    private static final String CACHEL_KEY_INNODB_SYNC_BINLOG = "sync_binlog";
    private static final String CACHEL_KEY_INNODB_FLUSH_LOG_AT_TRX_COMMIT = "innodb_flush_log_at_trx_commit";
    private static final String VALUE_BAKCUP_INNODB_BUFFER_POOL_SIZE = "1073741824";
    private static final String VALUE_RECOVER_INNODB_BUFFER_POOL_SIZE = "2147483648";
    private static final String VALUE_INNODB_SYNC_BINLOG = "1000";
    private static final String VALUE_INNODB_FLUSH_LOG_AT_TRX_COMMIT = "0";
    @Autowired
    DataSourceUtils dataSourceUtils;
    @Value(value="${system.database.type}")
    private int databaseType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goBackup(String sqlFile) throws IOException, InterruptedException {
        this.logger.debug("\u6267\u884c\u6570\u636e\u5e93\u5907\u4efd start...");
        if (DatabaseTypeEnum.MYSQL.type == this.databaseType) {
            String[] dburl = this.dataSourceUtils.dbUrlSplit(this.dataSourceUtils.getDbUrl());
            String pwd = this.dataSourceUtils.getDbPassword();
            String userName = this.dataSourceUtils.getDbUsername();
            HashMap<String, String> cacheData = new HashMap<String, String>();
            String mysqlConnectionString = this.getMysqlConnectionString(dburl, pwd, userName);
            this.backupBefore(mysqlConnectionString, cacheData);
            try {
                this.backup(mysqlConnectionString, sqlFile);
            }
            finally {
                this.backupAfter(mysqlConnectionString, cacheData);
            }
        }
        this.logger.debug("\u6267\u884c\u6570\u636e\u5e93\u5907\u4efd end.");
    }

    private void backupBefore(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
        this.sourceProfile();
        this.logger.info("\u6570\u636e\u5e93\u53c2\u6570\u914d\u7f6e\u4fe1\u606f-\u5907\u4efd:[{}]", (Object)JsonUtils.object2Json(cacheData));
    }

    private void backup(String mysqlConnectionString, String sqlFile) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        sb.append("mysqldump ").append(mysqlConnectionString).append(" --set-gtid-purged=off --opt >").append(sqlFile);
        String[] command = new String[3];
        this.prepareCommand(command);
        command[2] = sb.toString();
        this.logger.debug("\u5907\u4efd\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)sb);
        this.processCommand(command);
    }

    private void backupAfter(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goRecover(String sqlFile) throws IOException, InterruptedException {
        this.logger.debug("\u6267\u884c\u6570\u636e\u5e93\u6062\u590d start...");
        String[] dburl = this.dataSourceUtils.dbUrlSplit(this.dataSourceUtils.getDbUrl());
        String pwd = this.dataSourceUtils.getDbPassword();
        String userName = this.dataSourceUtils.getDbUsername();
        HashMap<String, String> cacheData = new HashMap<String, String>();
        String mysqlConnectionString = this.getMysqlConnectionString(dburl, pwd, userName);
        this.recoverBefore(mysqlConnectionString, cacheData);
        try {
            this.recover(mysqlConnectionString, sqlFile);
        }
        finally {
            this.recoverAfter(mysqlConnectionString, cacheData);
        }
        this.logger.debug("\u6267\u884c\u6570\u636e\u5e93\u6062\u590d end.");
    }

    private void recoverBefore(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
        this.sourceProfile();
        this.setInnodbFlushLogAtTrxCommit(mysqlConnectionString, cacheData);
        this.setInnodbSyncBinlog(mysqlConnectionString, cacheData);
        this.logger.info("\u6570\u636e\u5e93\u53c2\u6570\u914d\u7f6e\u4fe1\u606f-\u5907\u4efd:[{}]", (Object)JsonUtils.object2Json(cacheData));
    }

    private void recover(String mysqlConnectionString, String sqlFile) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        sb.append("mysql").append(mysqlConnectionString).append(" <").append(sqlFile);
        String[] command = new String[3];
        this.prepareCommand(command);
        command[2] = sb.toString();
        this.logger.info("\u8fd8\u539f\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)sb);
        this.processCommand(command);
    }

    private void recoverAfter(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
        String innodbFlushLogAtTrxCommit = cacheData.get(CACHEL_KEY_INNODB_FLUSH_LOG_AT_TRX_COMMIT);
        String innodbSyncBinlog = cacheData.get(CACHEL_KEY_INNODB_SYNC_BINLOG);
        StringBuilder sb = new StringBuilder();
        String[] command = new String[3];
        this.prepareCommand(command);
        sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append("  -e \"set global innodb_flush_log_at_trx_commit=").append(innodbFlushLogAtTrxCommit).append(";\" ");
        command[2] = sb.toString();
        this.processCommand(command);
        this.logger.info("\u6062\u590dinnodb_flush_log_at_trx_commit:[{}]", (Object)sb);
        sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append("  -e \"set global sync_binlog=").append(innodbSyncBinlog).append(";\" ");
        command[2] = sb.toString();
        this.processCommand(command);
        this.logger.info("\u6062\u590dsync_binlog:[{}]", (Object)sb);
    }

    private void setInnodbBufferPoolSize(String mysqlConnectionString, Map<String, String> cacheData, String newInnodbBufferPoolSize) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append(" -e \"select @@innodb_buffer_pool_size;\" 2> /dev/null | awk -F' ' '{print $NF}' | grep -v @@");
        String[] command = new String[3];
        this.prepareCommand(command);
        command[2] = sb.toString();
        String innodbBufferPoolSize = this.processCommand(command);
        cacheData.put(CACHEL_KEY_INNODB_BUFFER_POOL_SIZE, innodbBufferPoolSize);
        sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append("  -e \"set global innodb_buffer_pool_size=").append(newInnodbBufferPoolSize).append(";\"");
        command[2] = sb.toString();
        this.processCommand(command);
    }

    private void setInnodbFlushLogAtTrxCommit(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append(" -e \"select @@innodb_flush_log_at_trx_commit;\" 2> /dev/null | awk -F' ' '{print $NF}' | grep -v @@");
        String[] command = new String[3];
        this.prepareCommand(command);
        command[2] = sb.toString();
        String innodbFlushLogAtTrxCommit = this.processCommand(command);
        cacheData.put(CACHEL_KEY_INNODB_FLUSH_LOG_AT_TRX_COMMIT, innodbFlushLogAtTrxCommit);
        sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append("  -e \"set global innodb_flush_log_at_trx_commit=").append(VALUE_INNODB_FLUSH_LOG_AT_TRX_COMMIT).append(";\"");
        command[2] = sb.toString();
        this.processCommand(command);
    }

    private void setInnodbSyncBinlog(String mysqlConnectionString, Map<String, String> cacheData) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append(" -e \"select @@sync_binlog;\" 2> /dev/null | awk -F' ' '{print $NF}' | grep -v @@");
        String[] command = new String[3];
        this.prepareCommand(command);
        command[2] = sb.toString();
        String innodbSyncBinlog = this.processCommand(command);
        cacheData.put(CACHEL_KEY_INNODB_SYNC_BINLOG, innodbSyncBinlog);
        sb = new StringBuilder();
        sb.append("mysql ").append(mysqlConnectionString).append("  -e \"set global sync_binlog=").append(VALUE_INNODB_SYNC_BINLOG).append(";\" ");
        command[2] = sb.toString();
        this.processCommand(command);
    }

    private void sourceProfile() throws IOException, InterruptedException {
        if (!ConfigUtils.isWindows()) {
            String[] command = new String[]{"/bin/sh", "-c", "source /etc/profile\n source ~/.bash_profile"};
            this.logger.debug("sourceProfile\uff1a[{}]", (Object)command[2]);
            this.processCommand(command);
            this.logger.debug("sourceProfile\uff1aend.");
        }
    }

    private void prepareCommand(String[] command) {
        if (ConfigUtils.isWindows()) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/sh";
            command[1] = "-c";
        }
    }

    private String getMysqlConnectionString(String[] dburl, String pwd, String userName) {
        return " -h" + dburl[0] + " -P" + dburl[1] + " -u" + userName + " -p" + pwd + " " + dburl[2];
    }

    private String processCommand(String[] command) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        this.logger.debug("\u6267\u884c\u547d\u4ee4:[{}]", (Object)JsonUtils.object2Json(command));
        Process process = runtime.exec(command);
        InputStream input = process.getInputStream();
        String expMsg = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        int processComplete = process.waitFor();
        if (processComplete != 0) {
            InputStream errorStream = process.getErrorStream();
            String errorMsg = IOUtils.toString((InputStream)errorStream);
            throw new RuntimeException(errorMsg);
        }
        return expMsg;
    }
}

