/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConfigUtils {
    private static final String SYSTEM_DATABASE_TYPE = "system.database.type";
    public static final String SYSTEM_PROPERTY_KEY_BACKUP_ARTIFICIAL_TOTAL = "system_property_key_backup_artificial_total";
    public static final String SYSTEM_PROPERTY_KEY_BACKUP_ARTIFICIAL_INC = "system_property_key_backup_artificial_inc";
    private static String GLOBAL_CONF_ROOT;
    private static Integer RECOCERY_STATUS;
    private static String BACKUP_CONFIG_JSON;
    private static String BACKUP_FILE_HASH_JSON_FILE;
    private static String KEY_TOTAL_ZIP_FILE_NAME;
    private static String KEY_BACKUP_FILE_ZIP;
    private static String KEY_SQL_FILE_ZIP;
    private static String ZIP_PATH_SYS_CONFIG;
    private static String ZIP_PATH_HSM_YUNSDK;
    private static String ZIP_PATH_HSM_SANC;
    private static String ZIP_PATH_HSM_ALI;
    private static String ZIP_PATH_TOMCAT_CONFIG;
    private static String ZIP_PATH_SQL_CONFIG;

    public static String getBackupFileHashJsonFile() {
        return BACKUP_FILE_HASH_JSON_FILE;
    }

    public static String getKeyTotalZipFileName() {
        return KEY_TOTAL_ZIP_FILE_NAME;
    }

    public static String getKeyBackupFile() {
        return KEY_BACKUP_FILE_ZIP;
    }

    public static String getKeySqlFileKey() {
        return KEY_SQL_FILE_ZIP;
    }

    @Value(value="${config.path}")
    private void setConfPath(String confPath) {
        GLOBAL_CONF_ROOT = confPath;
    }

    public static void setRecoveryStatus(Integer recoveryStatus) {
        RECOCERY_STATUS = recoveryStatus;
    }

    public static Integer getRecoveryStatus() {
        return RECOCERY_STATUS;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").contains("Linux");
    }

    public static String getYunHsmConfPath() {
        String cfgPath = System.getenv("YUNHSMSDK_CONF");
        if (cfgPath != null) {
            cfgPath = ConfigUtils.isWindows() ? cfgPath.substring(0, cfgPath.lastIndexOf("\\")) : cfgPath.substring(0, cfgPath.lastIndexOf("/"));
            return cfgPath;
        }
        if (ConfigUtils.isWindows()) {
            return "C:\\Program Files\\yunhsmsdk\\conf";
        }
        return "/usr/local/yunhsmsdk/conf";
    }

    public static String getSancHsmConfPath() {
        return GMSSLSancHsmUtils.getConfPath((boolean)false);
    }

    public static String getAliHsmConfPath() {
        return GMSSLHsmUtils.getConfPath((boolean)false);
    }

    public static String getTomcatHomePath() {
        return System.getProperty("catalina.home");
    }

    public static String getTomcatConfPath() {
        return ConfigUtils.getTomcatHomePath() + "/conf";
    }

    public static String getSysConfPath() {
        return GLOBAL_CONF_ROOT;
    }

    public static String getZipSysConfPath() {
        return ZIP_PATH_SYS_CONFIG;
    }

    public static String getZipYunHsmConfPath() {
        return ZIP_PATH_HSM_YUNSDK;
    }

    public static String getZipSancHsmConfPath() {
        return ZIP_PATH_HSM_SANC;
    }

    public static String getZipAliHsmConfPath() {
        return ZIP_PATH_HSM_ALI;
    }

    public static String getZipTomcatConfPath() {
        return ZIP_PATH_TOMCAT_CONFIG;
    }

    public static String getZipSqlPath() {
        return ZIP_PATH_SQL_CONFIG;
    }

    public static String getBackupConfJsonFile() {
        return GLOBAL_CONF_ROOT + BACKUP_CONFIG_JSON;
    }

    public static int getSystemDatabaseType(Environment environment) {
        return Integer.valueOf(environment.getProperty(SYSTEM_DATABASE_TYPE));
    }

    static {
        BACKUP_CONFIG_JSON = "backupConfig.json";
        BACKUP_FILE_HASH_JSON_FILE = "backup_file_hash.json";
        KEY_TOTAL_ZIP_FILE_NAME = "totalZipFileName";
        KEY_BACKUP_FILE_ZIP = "backupFile.zip";
        KEY_SQL_FILE_ZIP = "data.sql.zip";
        ZIP_PATH_SYS_CONFIG = "sysConf";
        ZIP_PATH_HSM_YUNSDK = "yunhsmsdkConf";
        ZIP_PATH_HSM_SANC = "sancConf";
        ZIP_PATH_HSM_ALI = "aliConf";
        ZIP_PATH_TOMCAT_CONFIG = "tomcatConf";
        ZIP_PATH_SQL_CONFIG = "sql";
    }
}

