package com.xdja.pki.monitor.bean;


import com.xdja.pki.monitor.util.BigDecimalUtil;

/**
 * disk data
 *
 * @author liutao
 * @date 2020/6/30
 */
public class DiskData {
	/**
	 * disk total space
	 */
	private Long total;
	/**
	 * disk use space
	 */
	private Long use;
	/**
	 * memory free size
	 */
	private Long free;
	/**
	 * disk usage
	 */
	private Double usage;

	public DiskData() {
	}

	public DiskData(long total, long use,long free) {
		this.total = total;
		this.use = use;
		this.free = free;
		this.usage = BigDecimalUtil.div(use, total).doubleValue();
	}

	public Long getTotal() {
		return total;
	}

	public void setTotal(Long total) {
		this.total = total;
	}

	public Long getUse() {
		return use;
	}

	public void setUse(Long use) {
		this.use = use;
	}

	public Double getUsage() {
		return usage;
	}

	public void setUsage(Double usage) {
		this.usage = usage;
	}

	public Long getFree() {
		return free;
	}

	public void setFree(Long free) {
		this.free = free;
	}

	@Override
	public String toString() {
		return "DiskData{" +
				"total=" + total +
				", use=" + use +
				", free=" + free +
				", usage=" + usage +
				'}';
	}
}
