package com.xdja.pki.monitor.collector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * abstract collector
 *
 * @author liutao
 * @date 2020/6/30
 */
public abstract class AbstractCollector<T> implements Collector<T> {
	protected Logger log = LoggerFactory.getLogger(this.getClass());

	/**
	 * windows
	 */
	public static final int OS_TYPE_WINDOWS = 1;
	/**
	 * linux
	 */
	public static final int OS_TYPE_LINUX = 2;
	public static final String OS_NAME_WINDOWS = "windows";
	public static final String OS_NAME_LINUX = "linux";
	public static final int PERCENT = 100;

	@Override
	public void doCollect(CollectCallBack<T> callBack) {
		process(callBack);
	}

	/**
	 * get type of operation system
	 *
	 * @return os type : 1-windows 2-linux
	 */
	protected int getOsType() {
		int result = 0;
		String osName = System.getProperty("os.name").toLowerCase();
		if (osName.startsWith(OS_NAME_WINDOWS)) {
			result = OS_TYPE_WINDOWS;
		} else if (osName.startsWith(OS_NAME_LINUX)) {
			result = OS_TYPE_LINUX;
		}
		return result;
	}

	/**
	 * collect process
	 *
	 * @param callBack
	 */
	abstract void process(CollectCallBack<T> callBack);
}
