package com.xdja.pki.monitor.collector;

import com.xdja.pki.monitor.bean.MemoryData;
import com.xdja.pki.monitor.util.MonitorUtil;

/**
 * memory data collector
 *
 * @author liutao
 * @date 2020/6/30
 */
public class MemoryDataCollector extends AbstractCollector<MemoryData> {
	@Override
	void process(CollectCallBack<MemoryData> callBack) {
		try {
			MemoryData memoryData = MonitorUtil.monitorMemory();
			if (callBack != null) {
				callBack.onSuccess(memoryData);
			}
		} catch (Exception e) {
			if (callBack != null) {
				callBack.onError("memoryData collector error,msg:" + e.getMessage());
			}
			log.info("[MemoryDataCollector#process] error!", e);
		}

	}

}