package com.xdja.pki.monitor.collector;

import com.xdja.pki.monitor.bean.NicData;
import com.xdja.pki.monitor.util.MonitorUtil;

/**
 * network interface data collector
 *
 * @author liutao
 * @date 2020/6/30
 */
public class NicDataCollector extends AbstractCollector<NicData> {
	@Override
	void process(CollectCallBack<NicData> callBack) {
		try {
			NicData nicData = MonitorUtil.monitorNetWork();
			if (callBack != null) {
				callBack.onSuccess(nicData);
			}
		} catch (Exception e) {
			if (callBack != null) {
				callBack.onError("nicData collector error,msg:" + e.getMessage());
			}
			log.info("[NicDataCollector#process] error!", e);
		}
	}
}
