package com.xdja.pki.monitor.collector;

import com.xdja.pki.monitor.bean.SystemRuntimeData;
import com.xdja.pki.monitor.util.MonitorUtil;

/**
 * system runtime data collector
 *
 * @author liutao
 * @date 2020/6/30
 */
public class SystemRuntimeDataCollector extends AbstractCollector<SystemRuntimeData> {
	@Override
	void process(CollectCallBack<SystemRuntimeData> callBack) {
		try {
			if (getOsType() == OS_TYPE_LINUX) {
				SystemRuntimeData systemRuntimeData = MonitorUtil.monitorSystemRuntime(getOsType());
				if (callBack != null) {
					callBack.onSuccess(systemRuntimeData);
				}
			} else {
				if (callBack != null) {
					callBack.onError("support only linux");
				}
			}
		} catch (Exception e) {
			if (callBack != null) {
				callBack.onError("systemRuntimeData collector error,msg:" + e.getMessage());
			}
			log.info("[SystemRuntimeDataCollector#process] error!", e);
		}
	}
}