package com.xdja.pki.monitor.dao;

import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.monitor.dao.model.MonitorCpuDO;
import org.nutz.dao.Cnd;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * monitor_cpu
 */
@Repository
public class MonitorCpuDao extends BaseJdbcDao {
	/**
	 * 新增CPU监控信息
	 *
	 * @param monitorCpuDO
	 * @return MonitorCpuDO
	 */
	public MonitorCpuDO insertMonitorCpuData(MonitorCpuDO monitorCpuDO) {
		return daoTemplate.insert(monitorCpuDO);
	}

	/**
	 * 获取最近三小时CPU数据
	 *
	 * @param current 当前时间戳
	 * @return
	 */
	public List<MonitorCpuDO> queryRecentThreeHourData(long current) {
		//取出数据库最后一条数据
		Cnd lastOne = Cnd.NEW();
		lastOne.orderBy("id", "desc");
		lastOne.limit(0, 1);
		MonitorCpuDO lastCpuDO = this.daoTemplate.fetch(MonitorCpuDO.class, lastOne);
		long lastTime = (lastCpuDO == null) ? current : lastCpuDO.getGmtCreate().getTime();
		Long startTimeLong = DateUtils.getDatePreviousHour(lastTime, 3);
		// 计算三小时前的时间
		String startTime = DateUtils.longToStr(startTimeLong);
		String endTime = DateUtils.longToStr(current);
		Cnd cnd = Cnd.where("gmt_create", "between", new Object[]{startTime, endTime});
		cnd.orderBy("id", "asc");
		return this.daoTemplate.query(MonitorCpuDO.class, cnd);
	}

}
