package com.xdja.pki.monitor.dao.model;

import org.nutz.dao.entity.annotation.*;

import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * cpu利用率实体类
 *
 * @author yangmenghao
 * @date 2020/06/30 14:49:20
 */
@Table("monitor_cpu")
public class MonitorCpuDO {
	@Id
	@Column("id")
	@Comment("自增id")
	private Long id;
	@Column("utilization")
	@ColDefine(type = ColType.FLOAT, width = 8, precision = 5, notNull = true)
	@Comment("利用率")
	private BigDecimal utilization;
	@Column("gmt_create")
	@ColDefine(type = ColType.DATETIME, notNull = true)
	@Comment("创建时间")
	private Timestamp gmtCreate;

	public MonitorCpuDO() {
	}

	public MonitorCpuDO(BigDecimal utilization, Timestamp gmtCreate) {
		this.utilization = utilization;
		this.gmtCreate = gmtCreate;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public BigDecimal getUtilization() {
		return utilization;
	}

	public void setUtilization(BigDecimal utilization) {
		this.utilization = utilization;
	}

	public Timestamp getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Timestamp gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	@Override
	public String toString() {
		return "MonitorCpuDO{" +
				"id=" + id +
				", usage=" + utilization +
				", gmtCreate=" + gmtCreate +
				'}';
	}
}