package com.xdja.pki.monitor.factory;

import com.xdja.pki.monitor.bean.*;
import com.xdja.pki.monitor.collector.*;

/**
 * collector factory
 *
 * @author liutao
 * @date 2020/6/30
 */
public class CollectorFactory {
	public static <T> Collector<T> createCollector(Class<T> tClass) {
		Collector collector = null;
		if (tClass == CpuData.class) {
			collector = new CpuDataCollector();
		} else if (tClass == DiskData.class) {
			collector = new DiskDataCollector();
		} else if (tClass == MemoryData.class) {
			collector = new MemoryDataCollector();
		} else if (tClass == NicData.class) {
			collector = new NicDataCollector();
		} else if (tClass == SystemRuntimeData.class) {
			collector = new SystemRuntimeDataCollector();
		}
		return collector;
	}
}
