package com.xdja.pki.monitor.service;


import com.xdja.pki.core.bean.CoreResult;

/**
 * 监控服务
 *
 * @author yangmenghao
 * @date 2020/06/30
 */
public interface MonitorService {
	/**
	 * sprint7-获取内存当前使用率接口
	 *
	 * @param current timestamp
	 * @return
	 */
	CoreResult monitorMemoryData(long current);

	/**
	 * sprint7-获取硬盘当前使用率接口
	 *
	 * @param current timestamp
	 * @return
	 */
	CoreResult monitorDiskData(long current);

	/**
	 * sprint7-获取CPU历史使用率接口
	 *
	 * @param current timestamp
	 * @return
	 */
	CoreResult getCpuData(long current);

	/**
	 * 监控CPU资源
	 *
	 * @param current
	 * @return
	 */
	CoreResult monitorCpu(long current);

	/**
	 * sprint7-获取系统运行时常接口
	 *
	 * @param current timestamp
	 * @return
	 */
	CoreResult monitorSystemRunTimeData(long current);

	/**
	 * sprint7-获取各个网卡当前流量接口
	 *
	 * @param current timestamp
	 * @return
	 */
	CoreResult monitorNickData(long current);
}
