package com.xdja.pki.monitor.task;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.dao.MonitorCpuDao;
import com.xdja.pki.monitor.dao.model.MonitorCpuDO;
import com.xdja.pki.monitor.service.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * @author yangmenghao
 * @date 2020/07/14 14:00:11
 */
@Component
@Configurable
@EnableScheduling
public class PropertyTask {
	private final static Logger log = LoggerFactory.getLogger(PropertyTask.class);
	@Autowired
	private MonitorService monitorService;
	@Resource
	private MonitorCpuDao monitorCpuDao;

	/**
	 * monitor cpu spacing one quarter
	 */
	@Scheduled(cron = "${task.monitor.cpu.cron:0 */15 * * * ?}")
	public void monitorCpuForQuarter() {
		long current = System.currentTimeMillis();
		log.info("[PropertyTask#monitorCpuForQuarter]");
		CoreResult result = monitorService.monitorCpu(current);
		if (result.getInfo() != null) {
			CpuData cpuData = (CpuData) result.getInfo();
			monitorCpuDao.insertMonitorCpuData(new MonitorCpuDO(BigDecimal.valueOf(cpuData.getUsage()).setScale(5,
					BigDecimal.ROUND_HALF_UP), new Timestamp(current)));
		}
	}
}
