package com.xdja.pki.monitor.web.manager;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.monitor.common.ErrorEnum;
import com.xdja.pki.monitor.service.MonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * home page monitor
 *
 * @author yangmenghao
 * @date 2020/07/07 09:49:07
 */
@RestController
public class MonitorSystemController {
	private final Logger log = LoggerFactory.getLogger(MonitorSystemController.class);
	@Autowired
	private MonitorService monitorService;

	/**
	 * get system memory
	 *
	 * @return
	 */
	@PostMapping(value = "/v1/monitor/getMemoryData")
	public Object getMemoryData(HttpServletResponse resp) {
		long current = System.currentTimeMillis();
		CoreResult result;
		try {
			result = monitorService.monitorMemoryData(current);
		} catch (Exception e) {
			log.warn("[MonitorSystemController#getMemoryData] error", e);
			return CoreResult.failure(ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
		}
		/*if (!result.isSuccess()) {
			return result.getError().resp(resp);
		}*/
		log.info("[MonitorSystemController#getMemoryData]|{}|{}", current, result);
		return result.getInfo();
	}

	/**
	 * get system disk
	 *
	 * @return
	 */
	@PostMapping(value = "/v1/monitor/getDiskData")
	public Object getDiskData(HttpServletResponse resp) {
		long current = System.currentTimeMillis();
		CoreResult result;
		try {
			result = monitorService.monitorDiskData(current);
		} catch (Exception e) {
			log.warn("[MonitorSystemController#getDiskData] error", e);
			return CoreResult.failure(ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
		}
		/*if (!result.isSuccess()) {
			return result.getError().resp(resp);
		}*/
		log.info("[MonitorSystemController#getDiskData]|{}|{}", current, result);
		return result.getInfo();
	}

	/**
	 * get system cpu
	 *
	 * @return
	 */
	@PostMapping(value = "/v1/monitor/getCpuData")
	public Object getCpuData(HttpServletResponse resp) {
		long current = System.currentTimeMillis();
		CoreResult result;
		try {
			result = monitorService.getCpuData(current);
		} catch (Exception e) {
			log.warn("[MonitorSystemController#getCpuData] error", e);
			return CoreResult.failure(ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
		}
		/*if (!result.isSuccess()) {
			return result.getError().resp(resp);
		}*/
		log.info("[MonitorSystemController#getCpuData]|{}|{}", current, result);
		return result.getInfo();
	}

	/**
	 * get system  RunTime
	 *
	 * @return
	 */
	@PostMapping(value = "/v1/monitor/getSystemRunTimeData")
	public Object getSystemRunTimeData(HttpServletResponse resp) {
		long current = System.currentTimeMillis();
		CoreResult result;
		try {
			result = monitorService.monitorSystemRunTimeData(current);
		} catch (Exception e) {
			log.warn("[MonitorSystemController#getSystemRunTimeData] error", e);
			return CoreResult.failure(ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
		}
		/*if (!result.isSuccess()) {
			return result.getError().resp(resp);
		}*/
		log.info("[MonitorSystemController#getSystemRunTimeData]|{}|{}", current, result);
		return result.getInfo();
	}

	/**
	 * get system nic
	 *
	 * @return
	 */
	@PostMapping(value = "/v1/monitor/getNicData")
	public Object getNicData(HttpServletResponse resp) {
		long current = System.currentTimeMillis();
		CoreResult result;
		try {
			result = monitorService.monitorNickData(current);
		} catch (Exception e) {
			log.warn("[MonitorSystemController#getNicData] error", e);
			return CoreResult.failure(ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
		}
		/*if (!result.isSuccess()) {
			return result.getError().resp(resp);
		}*/
		log.info("[MonitorSystemController#getNicData]|{}|{}", current, result);
		return result.getInfo();
	}

}