/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.util;

import com.sun.management.OperatingSystemMXBean;
import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.bean.DiskData;
import com.xdja.pki.monitor.bean.MemoryData;
import com.xdja.pki.monitor.bean.NicDTO;
import com.xdja.pki.monitor.bean.NicData;
import com.xdja.pki.monitor.bean.SystemRuntimeData;
import com.xdja.pki.monitor.util.BigDecimalUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtil {
    private static final Logger log = LoggerFactory.getLogger(MonitorUtil.class);
    private static final String SYMBOL_COMMA = ",";
    private static final String SYMBOL_COLON = ":";
    private static final String SYMBOL_SPOT = ".";
    private static final String SYMBOL_SPACE = " ";
    private static final String LINE_REED = "\n";
    private static final String CMD_MONITOR_CPU = "top -b -n 1 | sed -n '3p'";
    private static final String FILE_NET = "/proc/net/dev";
    private static final String FILE_UPTIME = "/proc/uptime";
    private static OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public static SystemRuntimeData monitorSystemRuntime(int osType) {
        long uptime = -1L;
        if (osType == 1) {
            long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            uptime = (System.currentTimeMillis() - startTime) / 1000L;
        } else {
            String uptimeStr = MonitorUtil.readFile(FILE_UPTIME);
            uptime = Long.parseLong(MonitorUtil.getUptimeSecond(uptimeStr));
        }
        return new SystemRuntimeData(uptime);
    }

    public static String secondToDate(long seconds) {
        long days = seconds / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        long second = (seconds %= 60L) % 60L;
        return days + SYMBOL_COLON + hours + SYMBOL_COLON + minutes + SYMBOL_COLON + second;
    }

    public static NicData monitorNetWork() {
        NicData nicData = new NicData();
        String netWorks = MonitorUtil.readFile(FILE_NET);
        if (MonitorUtil.isEmpty(netWorks)) {
            return null;
        }
        Object[] netWorkArr = netWorks.split(LINE_REED);
        if (MonitorUtil.isEmpty(netWorkArr)) {
            return null;
        }
        ArrayList<NicDTO> netDataList = new ArrayList<NicDTO>(netWorkArr.length);
        for (Object netWork : netWorkArr) {
            NicDTO nicDTO = MonitorUtil.parserNetWork((String)netWork);
            if (nicDTO == null) continue;
            netDataList.add(nicDTO);
        }
        nicData.setList(netDataList);
        return nicData;
    }

    private static NicDTO parserNetWork(String netDataStr) {
        long kb = 1024L;
        if (MonitorUtil.isEmpty(netDataStr)) {
            return null;
        }
        Object[] metric = netDataStr.split(SYMBOL_COLON);
        if (MonitorUtil.isEmpty(metric) || metric.length == 1) {
            return null;
        }
        Object netName = metric[0];
        if (((String)netName).contains("lo")) {
            return null;
        }
        String dateStr = ((String)metric[1]).trim();
        String[] dataArr = dateStr.split("\\s+");
        long receive = Long.parseLong(dataArr[0]) / kb;
        long transmit = Long.parseLong(dataArr[8]) / kb;
        return new NicDTO((String)netName, transmit, receive);
    }

    public static MemoryData monitorMemory() {
        long kb = 1024L;
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalMemorySize = osmxb.getTotalPhysicalMemorySize() / kb;
        long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize() / kb;
        long usedMemory = totalMemorySize - freePhysicalMemorySize;
        BigDecimal usage = BigDecimalUtil.div(usedMemory, totalMemorySize);
        MemoryData memoryData = new MemoryData();
        memoryData.setTotal(totalMemorySize);
        memoryData.setUse(usedMemory);
        memoryData.setFree(freePhysicalMemorySize);
        memoryData.setUsage(usage.doubleValue());
        return memoryData;
    }

    public static CpuData monitorCpuByJdk() {
        double cpuLoad = osmxb.getSystemCpuLoad();
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            log.info("[MonitorUtil#monitorCpu] error!", (Throwable)e);
        }
        return new CpuData(osmxb.getSystemCpuLoad(), System.currentTimeMillis());
    }

    public static DiskData monitorDiskData() {
        long kb = 1024L;
        File[] files = File.listRoots();
        long total = 0L;
        long free = 0L;
        long used = 0L;
        for (File file : files) {
            total += file.getTotalSpace();
            free += file.getUsableSpace();
            used += file.getTotalSpace() - file.getUsableSpace();
        }
        return new DiskData(total / kb, used / kb, free / kb);
    }

    public static BigDecimal monitorCpuRateForLinux() {
        BigDecimal cpuUsage = null;
        Runtime runtime = Runtime.getRuntime();
        String[] cmdMonitorCpu = new String[]{"/bin/sh", "-c", CMD_MONITOR_CPU};
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(runtime.exec(cmdMonitorCpu).getInputStream()));){
            String cpuInfo = buffer.readLine();
            String[] split = cpuInfo.substring(0, cpuInfo.indexOf("id")).split(SYMBOL_COMMA, -1);
            BigDecimal idleUsage = new BigDecimal(split[split.length - 1].trim());
            cpuUsage = new BigDecimal(100).subtract(idleUsage);
        }
        catch (IOException e) {
            System.out.println("[MonitorUtil#monitorCpuRateForLinux] fail," + e.getMessage());
        }
        return cpuUsage;
    }

    private static String getUptimeSecond(String str) {
        String result = "0";
        if (str != null && str.length() != 0) {
            if (str.contains(SYMBOL_SPACE)) {
                String[] re = str.split(SYMBOL_SPACE);
                if (re.length > 0) {
                    String first = re[0];
                    result = first.contains(SYMBOL_SPOT) ? first.substring(0, first.indexOf(SYMBOL_SPOT)) : first;
                }
            } else {
                result = str.contains(SYMBOL_SPOT) ? str.substring(0, str.indexOf(SYMBOL_SPOT)) : str;
            }
        }
        return result;
    }

    private static String runCommand(String cmd) {
        StringBuilder info = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process pos = runtime.exec(cmd);
            InputStreamReader isr = new InputStreamReader(pos.getInputStream());
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((line = lnr.readLine()) != null) {
                info.append(line).append(LINE_REED);
            }
            if (info.length() > 1) {
                info.setLength(info.length() - 1);
            }
        }
        catch (Exception e) {
            log.info("[MonitorUtil#runCommand] cmd {} Exception!", (Object)cmd, (Object)e);
            return null;
        }
        return info.toString();
    }

    private static String readFile(String fileName) {
        StringBuilder info = new StringBuilder();
        try (FileInputStream in = new FileInputStream(new File(fileName));
             LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                info.append(line).append(LINE_REED);
            }
            if (info.length() > 1) {
                info.setLength(info.length() - 1);
            }
        }
        catch (Exception e) {
            log.info("[MonitorUtil#readFile] fileName {} Exception!", (Object)fileName, (Object)e);
            return null;
        }
        return info.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

