/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.collector;

import com.xdja.pki.monitor.collector.CollectCallBack;
import com.xdja.pki.monitor.collector.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollector<T>
implements Collector<T> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int OS_TYPE_WINDOWS = 1;
    public static final int OS_TYPE_LINUX = 2;
    public static final String OS_NAME_WINDOWS = "windows";
    public static final String OS_NAME_LINUX = "linux";
    public static final int PERCENT = 100;

    @Override
    public void doCollect(CollectCallBack<T> callBack) {
        this.process(callBack);
    }

    protected int getOsType() {
        int result = 0;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith(OS_NAME_WINDOWS)) {
            result = 1;
        } else if (osName.startsWith(OS_NAME_LINUX)) {
            result = 2;
        }
        return result;
    }

    abstract void process(CollectCallBack<T> var1);
}

