/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.dynamic.task;

import com.xdja.pki.core.utils.SpringBeanUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SchedulingRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String beanName;
    private String methodName;
    private String params;

    public SchedulingRunnable(String beanName, String methodName) {
        this(beanName, methodName, null);
    }

    public SchedulingRunnable(String beanName, String methodName, String params) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.params = params;
    }

    @Override
    public void run() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c - Bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.beanName, this.methodName, this.params});
        long startTime = System.currentTimeMillis();
        try {
            Object targetBean = SpringBeanUtils.getBean((String)this.beanName);
            Method method = null;
            method = StringUtils.isNotEmpty((CharSequence)this.params) ? targetBean.getClass().getDeclaredMethod(this.methodName, String.class) : targetBean.getClass().getDeclaredMethod(this.methodName, new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            if (StringUtils.isNotEmpty((CharSequence)this.params)) {
                method.invoke(targetBean, this.params);
            } else {
                method.invoke(targetBean, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - Bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s ", this.beanName, this.methodName, this.params), (Throwable)e);
        }
        long times = System.currentTimeMillis() - startTime;
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - Bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{this.beanName, this.methodName, this.params, times});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunnable that = (SchedulingRunnable)o;
        if (this.params == null) {
            return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && that.params == null;
        }
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && this.params.equals(that.params);
    }

    public int hashCode() {
        if (this.params == null) {
            return Objects.hash(this.beanName, this.methodName);
        }
        return Objects.hash(this.beanName, this.methodName, this.params);
    }
}

