/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.model.ContactUserDO;
import com.xdja.pki.ra.manager.dao.model.DeviceUserDO;
import com.xdja.pki.ra.manager.dto.DeviceUserDTO;
import com.xdja.pki.ra.manager.dto.DeviceUserDetailsDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceUserDao
extends BaseJdbcDao {
    @Autowired
    private BaseUserDao baseUserDao;

    public DeviceUserDO addDeviceUser(DeviceUserDO deviceUserDO) {
        return (DeviceUserDO)this.daoTemplate.insert((Object)deviceUserDO);
    }

    public int queryDeviceUser(String licenseNumber, int licenseType) {
        String sql = "SELECT count(1) FROM device_user WHERE  license_number=:licenseNumber and  license_type=:licenseType";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("licenseType", (Object)licenseType);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public DeviceUserDO getDeviceUser(Integer licenseType, String deviceNumber, String systemFlag) {
        try {
            return (DeviceUserDO)this.daoTemplate.fetch(DeviceUserDO.class, (Condition)Cnd.where((String)"user_id", (String)"=", (Object)this.baseUserDao.getUserId(UserTypeEnum.DEVICE_USER.id, systemFlag, licenseType, deviceNumber)));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int queryDeviceUser(long id, String licenseNumber, int licenseType) {
        String sql = "SELECT count(1) FROM device_user WHERE license_number=:licenseNumber AND license_type = :licenseType AND user_id !=:id";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("licenseType", (Object)licenseType);
        params.addValue("id", (Object)id);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public Long getUserId(Integer identType, String licenseNumber) {
        try {
            String sql = "SELECT user_id from device_user WHERE license_type =:licenseType AND license_number = :licenseNumber";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            return this.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public DeviceUserDO getDeviceInfoById(long deviceId) {
        return (DeviceUserDO)this.daoTemplate.fetch(DeviceUserDO.class, (Condition)Cnd.where((String)"user_id", (String)"=", (Object)deviceId));
    }

    public ContactUserDO getDeviceContactById(long userId) {
        return (ContactUserDO)this.daoTemplate.fetch(ContactUserDO.class, (Condition)Cnd.where((String)"user_id", (String)"=", (Object)userId));
    }

    public int updateDeviceUser(DeviceUserDO deviceUserDO) {
        return this.daoTemplate.updateIgnoreNull((Object)deviceUserDO);
    }

    public int updateDeviceUser(int id, int status) {
        String sql = "UPDATE base_user SET  status=:status WHERE id=:id";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("id", (Object)id);
        params.addValue("status", (Object)status);
        return this.executeSql(sql, (SqlParameterSource)params);
    }

    public int updateContactUser(ContactUserDO contactUserDO) {
        return this.daoTemplate.updateIgnoreNull((Object)contactUserDO);
    }

    public DeviceUserDetailsDTO queryDeviceDetails(Integer licenseType, String deviceNumber, String systemFlag) {
        try {
            String sql = "SELECT d.license_type AS licenseType, c.address AS address,  c.email AS email, c.person_name AS userName, d.gmt_update AS gmtUpdate, d.gmt_create AS gmtCreate, c.postal_code AS postCode, c.tel_number AS telNumber, d.remark AS remark,d.person_id AS personID, c.sex AS sex, d.device_desc AS deviceDesc,d.device_name AS deviceName,d.license_number AS deviceNumber, c.license_number AS userLicenseNumber ,c.license_type AS userLicenseType,b.user_type AS userType,b.system_flag AS systemFlag,b.status AS status FROM device_user AS d LEFT JOIN contact_user AS c ON d.user_id = c.user_id LEFT JOIN base_user AS b ON b.id = d.user_id WHERE d.license_type = :licenseType and d.license_number= :deviceNumber and b.system_flag = :systemFlag";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)licenseType);
            params.addValue("deviceNumber", (Object)deviceNumber);
            params.addValue("systemFlag", (Object)systemFlag);
            DeviceUserDetailsDTO deviceUserDetailsDTO = (DeviceUserDetailsDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(DeviceUserDetailsDTO.class));
            return deviceUserDetailsDTO;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public DeviceUserDetailsDTO queryDeviceDetails(long deviceId) {
        String sql = "SELECT d.license_type AS licenseType, c.address AS address,  c.email AS email, c.person_name AS userName, d.gmt_update AS gmtUpdate, d.gmt_create AS gmtCreate, c.postal_code AS postCode, c.tel_number AS telNumber, d.remark AS remark, c.sex AS sex, d.device_desc AS deviceDesc,d.device_name AS deviceName,d.license_number AS deviceNumber, c.license_number AS userLicenseNumber ,c.license_type AS userLicenseType,b.user_type AS userType,b.system_flag AS systemFlag,b.status AS status FROM device_user AS d LEFT JOIN contact_user AS c ON d.user_id = c.user_id LEFT JOIN base_user AS b ON b.id = d.user_id WHERE b.id = :deviceId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("deviceId", (Object)deviceId);
        DeviceUserDetailsDTO deviceUserDetailsDTO = (DeviceUserDetailsDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(DeviceUserDetailsDTO.class));
        return deviceUserDetailsDTO;
    }

    public PageInfo<DeviceUserDTO> listPageDeviceUser(String deviceName, String deviceNumber, int status, int pageIndex, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT d.user_id AS id, c.person_name AS userName, c.tel_number AS telNumber, b.id AS user_Id,b.system_flag as systemFlag,  d.license_number AS licenseNumber, d.gmt_create AS gmtCreate, d.device_name AS deviceName, a.customer_sys_name AS systemName, d.license_type AS licenseType, b.status AS status");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM device_user AS d , contact_user AS c , base_user AS b ,customer_sys a  ");
        fromSql.append(" WHERE c.id = d.person_id AND b.id = d.user_id AND b.system_flag = a.customer_sys_number ");
        if (StringUtils.isNotBlank((CharSequence)deviceName)) {
            fromSql.append(" AND d.device_name like :deviceName");
            params.addValue("deviceName", (Object)("%" + deviceName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)deviceNumber)) {
            fromSql.append(" AND d.license_number like :deviceNumber");
            params.addValue("deviceNumber", (Object)("%" + deviceNumber + "%"));
        }
        if (status != -1) {
            fromSql.append(" AND b.status = :status");
            params.addValue("status", (Object)status);
        }
        fromSql.append(" ORDER BY b.gmt_create DESC ");
        countSql.append((CharSequence)fromSql);
        PageInfo<DeviceUserDTO> page = new PageInfo<DeviceUserDTO>(pageIndex, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(DeviceUserDTO.class)));
        return page;
    }

    public int getIdByUserNo(String userNo) {
        String sql = "SELECT id FROM base_user WHERE user_no=:userNo";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userNo", (Object)userNo);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public List<DeviceUserDTO> queryDeviceUserByLicenseType(String licenseNumber, int licenseType) {
        String sql = "SELECT d.user_id AS id, c.person_name AS userName, c.tel_number AS telNumber, b.id AS user_Id, d.license_number AS licenseNumber, d.gmt_create AS gmtCreate, d.device_name AS deviceName, d.license_type AS licenseType,  b.status AS status  FROM device_user AS d LEFT JOIN contact_user AS c ON c.id = d.person_id LEFT JOIN base_user AS b ON b.id = d.user_id   WHERE  d.license_number=:licenseNumber AND d.license_type = :licenseType  AND b.system_flag = 'V2X' AND b.user_type = 3";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("licenseType", (Object)licenseType);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(DeviceUserDTO.class));
    }
}

