/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.PersonUserDO;
import com.xdja.pki.ra.manager.dto.PersonUserDTO;
import com.xdja.pki.ra.manager.dto.PersonUserDetailsDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PersonUserDao
extends BaseJdbcDao {
    public PageInfo<PersonUserDTO> listPagePersonUser(String personName, String licenseNumber, int status, int pageNo, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT a.user_id AS id,  b.id AS userId , b.system_flag AS systemFlag, a.person_no AS personNo, a.person_name AS personName, a.license_type AS licenseType, a.license_number AS licenseNumber,a.tel_number AS telNumber, b.status AS status,c.customer_sys_name AS systemName, a.company_name AS companyName,a.gmt_create AS gmtCreate");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM person_user a, base_user b , customer_sys c WHERE b.system_flag = c.customer_sys_number AND  a.user_id = b.id");
        if (StringUtils.isNotBlank((CharSequence)personName)) {
            fromSql.append(" AND a.person_name like :personName");
            params.addValue("personName", (Object)("%" + personName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)licenseNumber)) {
            fromSql.append(" AND a.license_number like :licenseNumber");
            params.addValue("licenseNumber", (Object)("%" + licenseNumber + "%"));
        }
        if (status != -1) {
            fromSql.append(" AND b.status = :status");
            params.addValue("status", (Object)status);
        }
        fromSql.append(" AND a.person_user_type = 0");
        fromSql.append(" ORDER BY a.gmt_create DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo<PersonUserDTO> page = new PageInfo<PersonUserDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(PersonUserDTO.class)));
        return page;
    }

    public PersonUserDO getPersonUser(long userId) {
        return (PersonUserDO)this.daoTemplate.fetch(PersonUserDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
    }

    public PersonUserDO savePersonUserInfo(PersonUserDO personUser) {
        return (PersonUserDO)this.daoTemplate.insert((Object)personUser);
    }

    public Long getUserId(Integer identType, String licenseNumber, String systemFlag) {
        try {
            String sql = "SELECT user_id From person_user WHERE license_type = :licenseType AND license_number = :licenseNumber ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public PersonUserDO addPersonUserInfo(PersonUserDO personUserDO) {
        return (PersonUserDO)this.daoTemplate.insert((Object)personUserDO);
    }

    public PersonUserDTO getPersonInfoByLicenseTypeAndLicenseNumber(Integer identType, String licenseNumber, String systemFlag) {
        try {
            String sql = "SELECT p.user_id AS userId, p.person_name AS personName ,p.sex AS sex,p.license_type AS licenseType,p.license_number AS licenseNumber, p.tel_number AS telNumber ,p.address AS address,p.email AS  email,p.postal_code AS postalCode,p.company_name AS companyName,p.company_address AS companyAddress,p.remark AS remark ,p.gmt_create AS gmtCreate, b.status AS status, b.system_flag AS systemFlag FROM person_user AS p LEFT JOIN base_user AS b ON p.user_id = b.id  WHERE p.license_type =:licenseType and p.license_number =:licenseNumber and b.system_flag = :systemFlag";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            params.addValue("systemFlag", (Object)systemFlag);
            return (PersonUserDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(PersonUserDTO.class));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int updatePersonUser(PersonUserDO personInfo) {
        return this.daoTemplate.updateIgnoreNull((Object)personInfo);
    }

    public PersonUserDetailsDTO getPersonDetailsInfoById(long personId) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT p.user_id AS id, p.person_name AS personName ,p.sex AS sex,p.license_type AS licenseType,p.license_number AS licenseNumber, p.tel_number AS telNumber ,p.address AS address,p.email AS  email,p.postal_code AS postalCode,p.company_name AS companyName,p.company_address AS companyAddress,p.remark AS remark ,p.gmt_create AS gmtCreate, b.status AS status, b.system_flag AS systemFlag FROM person_user AS p LEFT JOIN base_user AS b ON p.user_id = b.id  WHERE b.id = :personId";
        params.addValue("personId", (Object)personId);
        return (PersonUserDetailsDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(PersonUserDetailsDTO.class));
    }

    public PersonUserDO getPersonInfoById(long personId) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            String sql = "SELECT p.id AS id, p.user_id AS userId, p.person_no AS personNo,p.gmt_update AS gmtUpdate, p.person_name AS personName ,p.sex AS sex,p.license_type AS licenseType,p.license_number AS licenseNumber, p.tel_number AS telNumber ,p.address AS address,p.email AS  email,p.postal_code AS postalCode,p.company_name AS companyName,p.company_address AS companyAddress,p.remark AS remark ,p.gmt_create AS gmtCreate, b.status AS status  FROM person_user AS p LEFT JOIN base_user AS b ON p.user_id = b.id  WHERE  p.user_id = :personId";
            params.addValue("personId", (Object)personId);
            return (PersonUserDO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(PersonUserDO.class));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

