/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.RecoveryApplyDO;
import com.xdja.pki.ra.manager.dto.RecoveryApplyDTO;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RecoveryApplyDao
extends BaseJdbcDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryApplyDao.class);

    public RecoveryApplyDO getRecoveryApplyInfoByApplyId(long applyId) {
        return (RecoveryApplyDO)this.daoTemplate.fetch(RecoveryApplyDO.class, (Condition)Cnd.where((String)"applyId", (String)"=", (Object)applyId));
    }

    public RecoveryApplyDO insertRecoveryApply(RecoveryApplyDO recoveryApplyDO) {
        return (RecoveryApplyDO)this.daoTemplate.insert((Object)recoveryApplyDO);
    }

    public RecoveryApplyDTO getRecoveryApplyInfoByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT a.`user_id` userId,a.apply_no applyNo,c.`user_name` userName,c.`user_type` userType,").append("c.`status` userStatus,c.`license_type` licenseType ,c.`license_number` licenseNumber, b.`cert_patterm` AS certPatterm ,").append("b.`temp_name` tempName, b.`id` tempId, b.`temp_no` tempNo, b.temp_paras tempParas, b.`public_key_alg` AS keyAlg, a.`cert_dn` certDn,").append("d.`apply_id` applyId,d.`apply_reason` applyReason,a.`apply_type` applyType, c.system_flag AS systemFlag,").append("a.`apply_status` applyStatus,d.`sign_sn` signSn,d.`enc_sn` encSn,d.`sign_alg` signAlg,").append("d.`private_key_length` privateKeyLength,d.`cert_validity` certValidity,d.`gmt_create` gmtCreate,e.customer_sys_name AS systemName").append(" FROM `cert_apply` a,`cert_template` b,`base_user` c ,`apply_recovery` d, customer_sys e ").append(" WHERE a.`temp_id` = b.`id` AND a.`user_id` = c.`id` AND a.id = d.apply_id ").append(" AND c.system_flag = e.customer_sys_number AND a.`apply_no` = :applyNo");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        RecoveryApplyDTO recoveryApplyDTO = null;
        try {
            recoveryApplyDTO = (RecoveryApplyDTO)this.queryForObject(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(RecoveryApplyDTO.class));
        }
        catch (EmptyResultDataAccessException e) {
            LOGGER.info("[RecoveryApplyDao#getRecoveryApplyInfoByApplyNo] union select result by [applyNo={}] is null.", (Object)applyNo);
        }
        return recoveryApplyDTO;
    }

    public int getUnClosedRecoveryApplyNum(String signSn) {
        String sql = "SELECT COUNT(*) FROM `apply_recovery` a,`cert_apply` b WHERE a.`apply_id` = b.`id` AND b.`apply_status` IN (1,3) AND a.`sign_sn` =:signSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }
}

