/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class UserCertDao
extends BaseJdbcDao {
    public PageInfo<UserCertDTO> listPageUserCert(String certDn, int userType, String userName, int pageNo, int pageSize, Boolean effectiveTimeAsc, Boolean failureTimeAsc, int leftDate) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT  a.id ,a.user_id AS userId, a.temp_id AS tempId, c.`cert_patterm` AS certPatterm ,c.check_strategy AS checkStrategy, b.system_flag AS systemFlag, c.temp_no AS tempNo,a.cert_dn AS certDn,a.cert_sn AS signSn, d.cert_sn AS encSn,a.sign_alg AS signAlg, a.private_key_length AS privateKeyLength,  b.user_name AS userName, c.temp_name AS tempName, b.user_type AS userType, a.cert_status AS certStatus, a.effective_time AS effectiveTime,a.failure_time AS failureTime,a.cert_validity AS certValidity,a.is_recovery AS isRecovery,e.customer_sys_name AS systemName");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM user_cert a,base_user b ,cert_template c, user_cert d, customer_sys e WHERE b.system_flag = e.customer_sys_number AND a.`temp_id` = c.`id` AND a.`user_id`= b.`id` AND a.cert_status != 0 AND \n((a.`cert_type`=2 AND d.`cert_type`=3 AND a.`pair_cert_index` = d.`pair_cert_index`) \nOR (a.`cert_type`=1 AND d.`cert_type`=1 AND a.`pair_cert_index`= d.`pair_cert_index`)OR (a.`cert_type`=2 AND d.`cert_type`=2 AND a.`pair_cert_index` = d.`pair_cert_index` AND a.`is_recovery`=1 )) ");
        if (leftDate > 0) {
            Object afterAmountTime = DateUtils.getAfterAmountTime((int)Constants.SYSTEM_DATABASE_TYPE, (Integer)leftDate);
            Object nowDate = DateUtils.getTimeObject((int)Constants.SYSTEM_DATABASE_TYPE);
            fromSql.append(" AND a.failure_time  <= :afterAmountTime");
            fromSql.append(" AND a.cert_status = 1");
            fromSql.append(" AND a.failure_time > :nowDate");
            params.addValue("afterAmountTime", afterAmountTime);
            params.addValue("nowDate", nowDate);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            fromSql.append(" AND b.user_name like :userName");
            params.addValue("userName", (Object)("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            fromSql.append(" AND a.cert_dn like :certDn");
            params.addValue("certDn", (Object)("%" + certDn + "%"));
        }
        if (userType != 0) {
            fromSql.append(" AND b.user_type = :userType");
            params.addValue("userType", (Object)userType);
        }
        if (effectiveTimeAsc == null && failureTimeAsc == null) {
            fromSql.append(" ORDER BY a.gmt_create DESC");
        }
        if (effectiveTimeAsc != null) {
            if (effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time ASC");
            }
            if (!effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time DESC");
            }
        }
        if (failureTimeAsc != null) {
            if (failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time ASC");
            }
            if (!failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time DESC");
            }
        }
        countSql.append((CharSequence)fromSql);
        PageInfo<UserCertDTO> page = new PageInfo<UserCertDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDTO.class)));
        return page;
    }

    public PageInfo<UserCertDTO> listPageUserCertNew(String certDn, String userCA, String userName, int pageNo, int pageSize, Boolean effectiveTimeAsc, Boolean failureTimeAsc, int leftDate) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT a.id ,a.user_id AS userId, a.temp_id AS tempId,b.system_flag AS systemFlag, a.cert_dn AS certDn,a.cert_sn AS signSn,  d.cert_sn AS encSn,a.sign_alg AS signAlg, a.private_key_length AS privateKeyLength,  b.user_name AS userName,  b.user_type AS userType, a.cert_status AS certStatus, a.effective_time AS effectiveTime,  a.failure_time AS failureTime,a.cert_validity AS certValidity,a.is_recovery AS isRecovery ");
        selectSql.append(" FROM user_cert a, base_user b, cert_template c , user_cert d WHERE a.cert_status != 0 AND a.`user_id`= b.`id` AND a.`temp_id` = c.`id` AND ((a.`cert_type`=2 AND d.`cert_type`=3 AND a.`pair_cert_index` = d.`pair_cert_index`)  OR (a.`cert_type`=1 AND d.`cert_type`=1 AND a.`pair_cert_index`= d.`pair_cert_index`)  OR (a.`cert_type`=2 AND d.`cert_type`=2 AND a.`pair_cert_index` = d.`pair_cert_index` AND a.`is_recovery`=1 )) ");
        countSql.append(" FROM user_cert a, base_user b, cert_template c WHERE  a.cert_status != 0 AND a.`user_id`= b.`id` AND a.`temp_id` = c.`id` AND a.`cert_type`!= 3 ");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (leftDate > 0) {
            Object afterAmountTime = DateUtils.getAfterAmountTime((int)Constants.SYSTEM_DATABASE_TYPE, (Integer)leftDate);
            Object nowDate = DateUtils.getTimeObject((int)Constants.SYSTEM_DATABASE_TYPE);
            fromSql.append(" AND a.failure_time  <= :afterAmountTime");
            fromSql.append(" AND a.cert_status = 1");
            fromSql.append(" AND a.failure_time > :nowDate");
            params.addValue("afterAmountTime", afterAmountTime);
            params.addValue("nowDate", nowDate);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            fromSql.append(" AND b.user_name like :userName");
            params.addValue("userName", (Object)("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            fromSql.append(" AND a.cert_dn like :certDn");
            params.addValue("certDn", (Object)("%" + certDn + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)userCA)) {
            fromSql.append(" AND c.user_ca like :userCA");
            params.addValue("userCA", (Object)("%" + userCA + "%"));
        }
        if (effectiveTimeAsc == null && failureTimeAsc == null) {
            fromSql.append(" ORDER BY a.gmt_create DESC");
        }
        if (effectiveTimeAsc != null) {
            if (effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time ASC");
            }
            if (!effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time DESC");
            }
        }
        if (failureTimeAsc != null) {
            if (failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time ASC");
            }
            if (!failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time DESC");
            }
        }
        countSql.append((CharSequence)fromSql);
        PageInfo<UserCertDTO> page = new PageInfo<UserCertDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDTO.class)));
        return page;
    }

    public UserCertDTO getCertListInfo(String systemFlag, long tempId) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT c.user_ca AS userCA, c.`cert_patterm` AS certPatterm , c.temp_no AS tempNo,c.temp_name AS tempName,c.check_strategy AS checkStrategy, e.customer_sys_name AS systemName FROM cert_template c, customer_sys e WHERE e.customer_sys_number = :systemFlag AND c.`id` = :tempId";
        params.addValue("systemFlag", (Object)systemFlag);
        params.addValue("tempId", (Object)tempId);
        return (UserCertDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDTO.class));
    }

    public UserCertDO getUserCertBaseInfo(String signSn) {
        return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)signSn));
    }

    public int getUserIsHave(String signSn) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT COUNT(*)  FROM base_user WHERE id =(\nSELECT user_id FROM user_cert WHERE  cert_sn = :signSn\n) AND system_flag = 'V2X'";
        params.addValue("signSn", (Object)signSn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public UserCertDO getUserCertBaseInfoBySignSn(String signSn) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)signSn).and("cert_type", "in", list));
    }

    public UserCertDO insertUserCertInfo(UserCertDO userCertDO) {
        return (UserCertDO)this.daoTemplate.insert((Object)userCertDO);
    }

    public void deleteUserCert(long certSn) {
        String sql = "DELETE FROM user_cert WHERE certSn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        this.daoTemplate.deleteBySql(sql, (SqlParameterSource)params);
    }

    public int getUserCertByUserIdAndCertDN(String certDn, long userId) {
        String sql = "SELECT count(*) FROM user_cert WHERE cert_dn = :certDn AND user_id!=:userId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)certDn);
        params.addValue("userId", (Object)userId);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public int updateUserCertStatus(int certStatus, String certSn) {
        String sql = "UPDATE user_cert SET cert_status = :certStatus WHERE cert_sn = :certSn OR sign_cert_sn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        params.addValue("certStatus", (Object)certStatus);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public int updateDoubleUserCertStatus(int certStatus, String signCertSn) {
        String sql = "UPDATE user_cert SET cert_status = :certStatus WHERE pair_cert_index = (SELECT a.pair_cert_index FROM (SELECT pair_cert_index FROM user_cert WHERE cert_sn = :certSn  AND cert_type in(1, 2)) a )";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)signCertSn);
        params.addValue("certStatus", (Object)certStatus);
        int i = this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
        return i;
    }

    public List<UserCertDTO> getUserCertList(long userId) {
        try {
            String sql = "\nSELECT a.id, a.pair_cert_index AS pairCertIndex, a.cert_dn AS certDn, a.cert_sn AS signSn, a.cert_type AS certType, \n\td.cert_sn AS encSn, a.sign_alg AS signAlg, a.private_key_length AS privateKeyLength, a.cert_status AS certStatus,\n  a.effective_time AS effectiveTime, a.failure_time AS failureTime,a.cert_validity AS certValidity,a.is_recovery AS isRecovery\n\nFROM\n\nuser_cert a, user_cert d WHERE a.user_id = :userId AND a.cert_status != 0 \nAND ((a.`cert_type`=2 AND d.`cert_type`=3 AND a.`pair_cert_index` = d.`pair_cert_index`) \nOR (a.`cert_type`=1 AND d.`cert_type`=1 AND a.`pair_cert_index`= d.`pair_cert_index`)\nOR (a.`cert_type`=2 AND d.`cert_type`=2 AND a.`pair_cert_index` = d.`pair_cert_index` AND a.`is_recovery`=1 )) \n";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("userId", (Object)userId);
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDTO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
    }

    public UserCertDO getUserDetail(String certSn) {
        try {
            return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)certSn));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
        }
    }

    public Long getUserId(String signSn) {
        try {
            String sql = "SELECT user_id FROM user_cert WHERE cert_sn = :sn ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("sn", (Object)signSn);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public String getEncSnBySignSn(String signSn) {
        try {
            String sql = "SELECT cert_sn FROM user_cert WHERE sign_cert_sn = :signSn";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("signSn", (Object)signSn);
            return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int updateUserCert(UserCertDO userCertDO) {
        return this.daoTemplate.update((Object)userCertDO);
    }
}

