/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysTempDO;
import java.util.Date;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerTempDao
extends BaseJdbcDao {
    public List<CustomerSysTempDO> getCustomerTempInfoById(Long customer_sys_id) {
        String sql = "SELECT * FROM  customer_sys_temp WHERE  customer_sys_id=:customer_sys_id";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("customer_sys_id", (Object)customer_sys_id);
        try {
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysTempDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7b2c\u4e09\u65b9\u6a21\u677f\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CustomerSysTempDO> getCustomerTemplateByStatus(Long customsysId, int status) {
        String sql = "SELECT cus_temp.* FROM  customer_sys_temp cus_temp join cert_template temp on cus_temp.temp_no=temp.temp_no and temp.is_newest_temp=1  and cus_temp.customer_sys_id=:customsysId and temp.temp_status=:status";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("customsysId", (Object)customsysId).addValue("status", (Object)status);
        try {
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysTempDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7b2c\u4e09\u65b9\u7cfb\u7edf\u5df2\u505c\u7528\u7684\u6a21\u677f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void saveCustomerTemplate(CustomerSysTempDO customerSysTempDO) {
        try {
            CustomerSysTempDO customerTemplate = this.getExsitCustomerTemplate(customerSysTempDO);
            if (customerTemplate != null) {
                customerTemplate.setId(customerTemplate.getId());
                customerTemplate.setGmtCreate(null);
                customerTemplate.setGmtUpdate(new Date());
                this.daoTemplate.updateIgnoreNull((Object)customerTemplate);
            } else {
                customerSysTempDO.setGmtCreate(new Date());
                this.daoTemplate.insert((Object)customerSysTempDO);
            }
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58/\u66f4\u65b0\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public void resetCustomerTemplate(Long customsysId) {
        MapSqlParameterSource params = new MapSqlParameterSource("customsysId", (Object)customsysId);
        try {
            this.daoTemplate.deleteBySql("DELETE FROM customer_sys_temp WHERE customer_sys_id=:customsysId", (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u5220\u9664\u7b2c\u4e09\u65b9\u6388\u6743\u6a21\u677f\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<CertTempDO> getCustomerTemplateSelectList(Long customerId) {
        String sql = "select temp.* from customer_sys_temp cus_temp join cert_template temp on temp.is_newest_temp=1 and cus_temp.temp_no=temp.temp_no and temp.temp_status=2 and cus_temp.customer_sys_id=:customsysId order by temp.temp_no desc";
        MapSqlParameterSource sqlParam = new MapSqlParameterSource().addValue("customsysId", (Object)customerId);
        try {
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)sqlParam, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6a21\u677f\u4e0b\u62c9\u9009\u62e9\u5217\u8868\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    private CustomerSysTempDO getExsitCustomerTemplate(CustomerSysTempDO customerSysTempDO) {
        try {
            return (CustomerSysTempDO)this.daoTemplate.fetch(CustomerSysTempDO.class, (Condition)Cnd.where((String)"customerSysId", (String)"=", (Object)customerSysTempDO.getCustomerSysId()).and("tempNo", "=", (Object)customerSysTempDO.getTempNo()));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u5df2\u5b58\u5728\u7684\u7b2c\u4e09\u65b9\u6a21\u677f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

