/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.IssueApplyDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class IssueApplyDao
extends BaseJdbcDao {
    public IssueApplyDO getIssueApplyInfoByApplyId(long applyId) {
        return (IssueApplyDO)this.daoTemplate.fetch(IssueApplyDO.class, (Condition)Cnd.where((String)"applyId", (String)"=", (Object)applyId));
    }

    public IssueApplyDTO getIssueApplyInfoByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT a.`user_id` AS userId, a.`temp_id` AS tempId, a.`cert_dn` AS certDn, a.`apply_type` AS applyType, a.`apply_status` AS applyStatus, a.`gmt_create` AS gmtCreate, ");
        sql.append("b.`base_dn` AS baseDn, b.`cert_patterm` AS certPatterm, b.`temp_no` AS tempNo ,b.`temp_name` AS tempName, b.`public_key_alg` AS keyAlg, b.user_ca AS userCA, ");
        sql.append("c.`license_type` AS licenseType, c.`license_number` AS licenseNumber, c.`user_name` AS userName, c.`user_type` AS userType, c.`status` AS userStatus, c.system_flag AS systemFlag,");
        sql.append("d.`cert_validity` AS certValidity, d.`apply_id` AS applyId, d.`temp_paras` AS tempParas, d.`apply_reason` AS applyReason, d.`sign_alg` AS signAlg, d.`private_key_length` AS privateKeyLength, ");
        sql.append("e.customer_sys_name AS systemName ");
        sql.append("FROM cert_apply a, cert_template b, base_user c, apply_issue d, customer_sys e ");
        sql.append("WHERE a.`temp_id` = b.`id` AND c.system_flag = e.customer_sys_number AND a.`user_id` = c.`id` AND a.`id` = d.`apply_id` AND a.`apply_no`=:applyNo ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        IssueApplyDTO issueApplyDTO = (IssueApplyDTO)this.queryForObject(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(IssueApplyDTO.class));
        return issueApplyDTO;
    }

    public IssueApplyDO insertIssueApply(IssueApplyDO issueApplyDO) {
        return (IssueApplyDO)this.daoTemplate.insert((Object)issueApplyDO);
    }

    public int updateIssueApply(IssueApplyDO issueApplyDO) {
        return this.daoTemplate.updateIgnoreNull((Object)issueApplyDO);
    }
}

