/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysDO;
import com.xdja.pki.ra.manager.dto.StatisticsCertDTO;
import com.xdja.pki.ra.manager.dto.StatisticsCustomerDTO;
import com.xdja.pki.ra.manager.dto.StatisticsUserDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class StatisticsDao
extends BaseJdbcDao {
    @Deprecated
    public List<StatisticsCustomerDTO> getCustomerCertCountOld(String customerSysName, String startTime, String endTime) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String nameSelectSql = "";
        String nameSelectSql2 = "";
        String timeSelectSql = "";
        if (StringUtils.isNotBlank((CharSequence)customerSysName)) {
            nameSelectSql = " AND a.customer_sys_name like :customerSysName ";
            nameSelectSql2 = " AND c.customer_sys_name like :customerSysName ";
            params.addValue("customerSysName", (Object)("%" + customerSysName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeSelectSql = "AND a.gmt_create >= :startTime AND a.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String selectSql = "SELECT c.customer_sys_name AS customerSysName, t.system_flag AS customerSysNumber , t.normal, t.outdate, t.revoked, t.freeze, t.total\n                FROM\n                (SELECT \n                coalesce(system_flag, null) AS system_flag, \n                SUM(normal) normal, SUM(outdate) outdate, SUM(revoked) revoked, SUM(freeze) freeze, SUM(total) total\n                FROM\n                (SELECT a.customer_sys_number AS system_flag, 0 normal, 0 outdate, 0 revoked, 0 freeze, 0 total\n                FROM customer_sys a \n                WHERE a.customer_sys_number != 'V2X' AND a.customer_sys_number != 'RA' " + nameSelectSql + " UNION ALL\n   SELECT  system_flag AS systemflag, \n                COUNT(IF(cert_status = 1 AND failure_time > NOW() , 1, NULL)) normal,\n                COUNT(IF(failure_time <= NOW() AND cert_status != 0, 1, NULL)) outdate,\n                COUNT(IF(cert_status = 3 AND failure_time > NOW(), 1, NULL)) revoked,\n                COUNT(IF(cert_status = 4 AND failure_time > NOW() , 1, NULL)) freeze,\n                COUNT(IF(cert_status != 0 , 1, NULL)) total     FROM\n (SELECT b.system_flag ,a.cert_status, c.customer_sys_name AS customerSysName,a.failure_time\n FROM user_cert a, base_user b, customer_sys c \n WHERE b.id = a.user_id AND c.customer_sys_number != 'V2X' AND c.customer_sys_number != 'RA'  \n" + timeSelectSql + "  AND c.customer_sys_number = b.system_flag\n" + nameSelectSql2 + "  ) AS d\n  GROUP BY system_flag\n )AS e\n            GROUP BY system_flag WITH ROLLUP ) AS t\nLEFT JOIN customer_sys AS c  ON c.customer_sys_number = t.system_flag \n";
        return this.daoTemplate.queryForList(selectSql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCustomerDTO.class));
    }

    public List<StatisticsCustomerDTO> getCustomerCertCount(String customerSysName, String startTime, String endTime) {
        ArrayList<StatisticsCustomerDTO> statisticsCustomerDTOS = new ArrayList<StatisticsCustomerDTO>();
        int normal = 0;
        int outdate = 0;
        int revoked = 0;
        int freeze = 0;
        int total = 0;
        List<CustomerSysDO> sysInfos = this.getSysInfo(customerSysName);
        for (CustomerSysDO sysInfo : sysInfos) {
            StatisticsCustomerDTO countOneSys = this.getCountOneSys(sysInfo.getCustomerSysNumber(), startTime, endTime);
            countOneSys.setCustomerSysName(sysInfo.getCustomerSysName());
            normal += countOneSys.getNormal();
            outdate += countOneSys.getOutdate();
            revoked += countOneSys.getRevoked();
            freeze += countOneSys.getFreeze();
            total += countOneSys.getTotal();
            statisticsCustomerDTOS.add(countOneSys);
        }
        StatisticsCustomerDTO totalDTO = new StatisticsCustomerDTO("", "\u5408\u8ba1", normal, outdate, revoked, freeze, total);
        statisticsCustomerDTOS.add(totalDTO);
        return statisticsCustomerDTOS;
    }

    public List<StatisticsCertDTO> getCertCount(String certTemplateName, String startTime, String endTime) {
        ArrayList<StatisticsCertDTO> statisticsCertDTOS = new ArrayList<StatisticsCertDTO>();
        int normal = 0;
        int outdate = 0;
        int revoked = 0;
        int freeze = 0;
        int total = 0;
        List<CertTempDO> certTempDOS = this.getTempNo(certTemplateName);
        for (CertTempDO certTemp : certTempDOS) {
            StatisticsCertDTO statisticsCertDTO = this.getCountOneTemp(certTemp.getTempNo(), startTime, endTime);
            statisticsCertDTO.setTempName(certTemp.getTempName());
            normal += statisticsCertDTO.getNormal();
            outdate += statisticsCertDTO.getOutdate();
            revoked += statisticsCertDTO.getRevoked();
            freeze += statisticsCertDTO.getFreeze();
            total += statisticsCertDTO.getTotal();
            statisticsCertDTOS.add(statisticsCertDTO);
        }
        StatisticsCertDTO totalDTO = new StatisticsCertDTO("\u5408\u8ba1", normal, outdate, revoked, freeze, total);
        statisticsCertDTOS.add(totalDTO);
        return statisticsCertDTOS;
    }

    public List<CertTempDO> getTempNo(String tempName) {
        List certTempDOS;
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder("SELECT temp_no ,temp_name from cert_template WHERE is_newest_temp = 1 ");
        try {
            if (StringUtils.isNotBlank((CharSequence)tempName)) {
                params.addValue("tempName", (Object)tempName);
                sql.append("AND temp_name = :tempName ");
            }
            certTempDOS = this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
        }
        catch (DataAccessException e) {
            return null;
        }
        return certTempDOS;
    }

    public List<CustomerSysDO> getSysInfo(String systemName) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            StringBuilder sql = new StringBuilder("SELECT customer_sys_number, customer_sys_name FROM customer_sys  WHERE customer_sys_number != 'V2X' AND customer_sys_number != 'RA' ");
            if (StringUtils.isNotBlank((CharSequence)systemName)) {
                params.addValue("systemName", (Object)("%" + systemName + "%"));
                sql.append("AND customer_sys_name  like :systemName");
            }
            return this.daoTemplate.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysDO.class));
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public StatisticsCertDTO getCountOneTemp(String tempNo, String startTime, String endTime) {
        Object nowDate = DateUtils.getTimeObject((int)Constants.SYSTEM_DATABASE_TYPE);
        StringBuilder sqlAll = new StringBuilder("SELECT temp_no, normal, outdate, revoked, freeze, total FROM ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("tempNo", (Object)tempNo);
        params.addValue("nowDate", nowDate);
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = "AND a.gmt_create >= :startTime AND a.gmt_create <= :endTime ";
            startTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(endTime + " 23:59:59 "));
            params.addValue("startTime", (Object)startTime);
            params.addValue("endTime", (Object)endTime);
        }
        String fromSql = "FROM user_cert a WHERE a.temp_no = :tempNo ";
        StringBuilder sqlNormal = new StringBuilder();
        sqlNormal.append("(SELECT COUNT(*) AS normal ");
        sqlNormal.append(fromSql);
        sqlNormal.append(timeReqSql);
        sqlNormal.append("AND a.cert_status = 1 AND a.failure_time > :nowDate) c,");
        StringBuilder sqlOutDate = new StringBuilder();
        sqlOutDate.append("(SELECT COUNT(*) AS outdate ");
        sqlOutDate.append(fromSql);
        sqlOutDate.append(timeReqSql);
        sqlOutDate.append("AND cert_status != 0 AND failure_time <= :nowDate) d, ");
        StringBuilder sqlRevoked = new StringBuilder();
        sqlRevoked.append("(SELECT COUNT(*) AS revoked ");
        sqlRevoked.append(fromSql);
        sqlRevoked.append(timeReqSql);
        sqlRevoked.append("AND cert_status = 3 AND failure_time > :nowDate) e, ");
        StringBuilder sqlFreeze = new StringBuilder();
        sqlFreeze.append("(SELECT COUNT(*) AS freeze ");
        sqlFreeze.append(fromSql);
        sqlFreeze.append(timeReqSql);
        sqlFreeze.append("AND cert_status = 4 AND failure_time > :nowDate) f, ");
        StringBuilder sqlTotal = new StringBuilder();
        sqlTotal.append("(SELECT a.temp_no,  COUNT(*) AS total ");
        sqlTotal.append(fromSql);
        sqlTotal.append(timeReqSql);
        sqlTotal.append("AND cert_status != 0) g ");
        sqlAll.append((CharSequence)sqlNormal).append((CharSequence)sqlOutDate).append((CharSequence)sqlRevoked).append((CharSequence)sqlFreeze).append((CharSequence)sqlTotal);
        StatisticsCertDTO statisticsCertDTO = (StatisticsCertDTO)this.daoTemplate.queryForObject(sqlAll.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCertDTO.class));
        return statisticsCertDTO;
    }

    public StatisticsCustomerDTO getCountOneSys(String customerSysNumber, String startTime, String endTime) {
        Object nowDate = DateUtils.getTimeObject((int)Constants.SYSTEM_DATABASE_TYPE);
        StringBuilder sqlAll = new StringBuilder("SELECT customerSysNumber, normal, outdate, revoked, freeze, total FROM ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("customerSysNumber", (Object)customerSysNumber);
        params.addValue("nowDate", nowDate);
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = "AND x.gmt_create >= :startTime AND x.gmt_create <= :endTime ";
            startTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(endTime + " 23:59:59 "));
            params.addValue("startTime", (Object)startTime);
            params.addValue("endTime", (Object)endTime);
        }
        String fromSql = "FROM user_cert x ,base_user y WHERE y.id = x.user_id AND y.system_flag = :customerSysNumber ";
        StringBuilder sqlNormal = new StringBuilder();
        sqlNormal.append("(SELECT COUNT(*) AS normal ");
        sqlNormal.append(fromSql);
        sqlNormal.append(timeReqSql);
        sqlNormal.append("AND cert_status = 1 AND failure_time > :nowDate) a,");
        StringBuilder sqlOutDate = new StringBuilder();
        sqlOutDate.append("(SELECT COUNT(*) AS outdate ");
        sqlOutDate.append(fromSql);
        sqlOutDate.append(timeReqSql);
        sqlOutDate.append("AND cert_status != 0 AND failure_time <= :nowDate) b, ");
        StringBuilder sqlRevoked = new StringBuilder();
        sqlRevoked.append("(SELECT COUNT(*) AS revoked ");
        sqlRevoked.append(fromSql);
        sqlRevoked.append(timeReqSql);
        sqlRevoked.append("AND cert_status = 3 AND failure_time > :nowDate) c, ");
        StringBuilder sqlFreeze = new StringBuilder();
        sqlFreeze.append("(SELECT COUNT(*) AS freeze ");
        sqlFreeze.append(fromSql);
        sqlFreeze.append(timeReqSql);
        sqlFreeze.append("AND cert_status = 4 AND failure_time > :nowDate) d, ");
        StringBuilder sqlTotal = new StringBuilder();
        sqlTotal.append("(SELECT system_flag AS customerSysNumber, COUNT(*) AS total ");
        sqlTotal.append(fromSql);
        sqlTotal.append(timeReqSql);
        sqlTotal.append("AND cert_status != 0) e ");
        sqlAll.append((CharSequence)sqlNormal).append((CharSequence)sqlOutDate).append((CharSequence)sqlRevoked).append((CharSequence)sqlFreeze).append((CharSequence)sqlTotal);
        StatisticsCustomerDTO statisticsCustomerDTO = (StatisticsCustomerDTO)this.daoTemplate.queryForObject(sqlAll.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCustomerDTO.class));
        return statisticsCustomerDTO;
    }

    @Deprecated
    public List<StatisticsCertDTO> getCertCountOld(String certTemplateName, String startTime, String endTime) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String templateWhereReqSql = "";
        String templateAndReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)certTemplateName)) {
            templateWhereReqSql = "Where cert_template.temp_name = :certTemplateName ";
            templateAndReqSql = "AND cert_template.temp_name = :certTemplateName ";
            params.addValue("certTemplateName", (Object)certTemplateName);
        }
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = "AND user_cert.gmt_create >= :startTime AND user_cert.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String sql = "SELECT \nCASE WHEN temp_name IS NOT NULL THEN temp_name ELSE \"\u5408\u8ba1\" END AS temp_name,\nSUM(normal) normal, SUM(outdate) outdate, SUM(revoked) revoked, SUM(freeze) freeze,SUM(total) total FROM (\n\t\n\tSELECT\n\ttemp_name,\n\t0 normal,\n\t0 outdate,\n\t0 revoked,\n  0 freeze,\t0 total\n\tFROM cert_template \n" + templateWhereReqSql + "\t\n\tUNION ALL\n\t\n\tSELECT temp_name , \n\tCOUNT(IF(user_cert.cert_status = 1 AND user_cert.failure_time > NOW() , 1, NULL)) normal,\n\tCOUNT(IF(user_cert.failure_time <= NOW() AND user_cert.cert_status != 0, 1, NULL)) outdate,\n\tCOUNT(IF(user_cert.cert_status = 3 AND user_cert.failure_time > NOW(), 1, NULL)) revoked,\n  COUNT(IF(user_cert.cert_status = 4 AND user_cert.failure_time > NOW(), 1, NULL)) freeze,\tCOUNT(IF(user_cert.cert_status != 0 , 1, NULL)) total\n\tFROM cert_template \n\tLEFT JOIN user_cert ON user_cert.temp_no = cert_template.temp_no\n\tWHERE cert_template.is_newest_temp = 1 \n" + templateAndReqSql + timeReqSql + "\tGROUP BY temp_name\n\n) AS t GROUP BY temp_name WITH ROLLUP";
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCertDTO.class));
    }

    public List<StatisticsUserDTO> getUserCount(String startTime, String endTime) {
        ArrayList<StatisticsUserDTO> list = new ArrayList<StatisticsUserDTO>();
        StatisticsUserDTO person = new StatisticsUserDTO();
        int personNormal = this.countUser(UserTypeEnum.PERSON_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int personDisabled = this.countUser(UserTypeEnum.PERSON_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        person.setType(UserTypeEnum.PERSON_USER.id);
        person.setTypeString(UserTypeEnum.PERSON_USER.value);
        person.setNormal(personNormal);
        person.setDisabled(personDisabled);
        person.setTotal(personNormal + personDisabled);
        list.add(person);
        StatisticsUserDTO organ = new StatisticsUserDTO();
        int organNormal = this.countUser(UserTypeEnum.ORGAN_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int organDisabled = this.countUser(UserTypeEnum.ORGAN_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        organ.setType(UserTypeEnum.ORGAN_USER.id);
        organ.setTypeString(UserTypeEnum.ORGAN_USER.value);
        organ.setNormal(organNormal);
        organ.setDisabled(organDisabled);
        organ.setTotal(organNormal + organDisabled);
        list.add(organ);
        StatisticsUserDTO device = new StatisticsUserDTO();
        int deviceNormal = this.countUser(UserTypeEnum.DEVICE_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int deviceDisabled = this.countUser(UserTypeEnum.DEVICE_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        device.setType(UserTypeEnum.DEVICE_USER.id);
        device.setTypeString(UserTypeEnum.DEVICE_USER.value);
        device.setNormal(deviceNormal);
        device.setDisabled(deviceDisabled);
        device.setTotal(deviceNormal + deviceDisabled);
        list.add(device);
        return list;
    }

    private int countUser(int type, int status, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        cnd.and("user_type", "=", (Object)type);
        cnd.and("status", "=", (Object)status);
        if (UserTypeEnum.DEVICE_USER.id == type) {
            cnd.and("license_number", "!=", (Object)"scep");
        }
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            startTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)Constants.SYSTEM_DATABASE_TYPE, (String)(endTime + " 23:59:59 "));
            cnd.and("gmt_create", ">=", (Object)startTime);
            cnd.and("gmt_create", "<=", (Object)endTime);
        }
        return this.daoTemplate.count(BaseUserDO.class, (Condition)cnd);
    }

    public List<CertTempDO> getTemplate() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT temp_no,temp_name FROM cert_template GROUP BY temp_no ORDER BY temp_name";
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
    }
}

