/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.handler;

import com.xdja.ca.pkcs7.Pkcs7Utils;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.pkcs7.SignedAndEnvelopedData;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.handler.IScepMessageHandler;
import com.xdja.pki.ra.openapi.core.scep.CertRepUtils;
import com.xdja.pki.ra.service.manager.scep.ScepCertService;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="certReqScepMessageHandler")
public class CertReqScepMessageHandler
implements IScepMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ScepCertService scepCertService;

    public Result handleMessage(byte[] sourceData, byte[] transactionId, byte[] senderNonce, X509Certificate selfCert) {
        Result result = new Result();
        this.logger.info("SCEP\u8bc1\u4e66\u6ce8\u518c\u6d88\u606f\u5904\u7406\u7c7b\u63a5\u6536\u5230\u7684\u660e\u6587\u8bf7\u6c42\u6570\u636e:[{}] \u4e8b\u52a1id:[{}]", (Object)Base64.toBase64String((byte[])sourceData), (Object)Base64.toBase64String((byte[])transactionId));
        PKCS10CertificationRequest pkcs10CertificationRequest = null;
        try {
            pkcs10CertificationRequest = new PKCS10CertificationRequest(sourceData);
            this.logger.info("\u670d\u52a1\u7aef\u89e3\u6790\u83b7\u53d6\u5ba2\u6237\u7aef\u7684P10\u8bf7\u6c42\u5bf9\u8c61:[{}]", (Object)Base64.toBase64String((byte[])pkcs10CertificationRequest.getEncoded()));
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6P10\u65f6IO\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.RESOLVE_P10_EXCEPTION);
            return result;
        }
        try {
            result = this.scepCertService.issueScepCert(pkcs10CertificationRequest, Base64.toBase64String((byte[])transactionId));
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u7528\u6237\u6ce8\u518c\u7b7e\u53d1\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.ISSUE_CERT_EXCEPTION);
            return result;
        }
        SignedData repSignedData = null;
        X509Certificate serviceCert = CommonVariable.getRaServiceCert();
        try {
            if (result.isSuccess() && result.getInfo() != null) {
                UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
                String signCert = userCertInfo.getSignCert();
                X509Certificate sign = CertUtils.getCertFromStr((String)signCert);
                X509Certificate enc = null;
                SignedAndEnvelopedData signedAndEnvelopedData = null;
                if (null != userCertInfo.getEncCert()) {
                    String encCert = userCertInfo.getEncCert();
                    String encPrivateKey = userCertInfo.getEncPriKey();
                    enc = CertUtils.getCertFromStr((String)encCert);
                    signedAndEnvelopedData = SignedAndEnvelopedData.getInstance((Object)Base64.decode((String)encPrivateKey));
                }
                String extraCertsP7b = userCertInfo.getExtraCertsP7b();
                List x509Certificates = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
                SignedData sourceRepSignedData = CertRepUtils.createSourceRepSignedData((X509Certificate)sign, (X509Certificate)enc, (SignedAndEnvelopedData)signedAndEnvelopedData, null, null, (List)x509Certificates);
                ContentInfo sourceContentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sourceRepSignedData);
                repSignedData = CertRepUtils.createRepSignedData((byte[])sourceContentInfo.getEncoded("DER"), (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"0", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else if (result.isSuccess() && result.getInfo() == null) {
                this.logger.info("Service\u5c42\u8fd4\u56de\u7684\u7b49\u5f85\u7ed3\u679c\uff1a" + JsonUtils.object2Json((Object)result));
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"3", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else {
                this.logger.info("Service\u5c42\u8fd4\u56de\u7684\u5904\u7406\u9519\u8bef\u7ed3\u679c\uff1a" + JsonUtils.object2Json((Object)result));
                int failInfoByErrorCode = CertRepUtils.getFailInfoByErrorCode((int)result.getErrorBean().getErrCode());
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"2", (byte[])senderNonce, (X509Certificate)selfCert, (Integer)failInfoByErrorCode);
            }
            ContentInfo contentInfo = CertRepUtils.createContentInfo((ASN1ObjectIdentifier)PKCSObjectIdentifiers.signedData, (ASN1Encodable)repSignedData);
            result.setContentType("application/x-pki-message");
            result.setInfo((Object)contentInfo);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CREATE_CERT_REP_STRUCTURE_EXCEPTION);
            return result;
        }
    }
}

