/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.handler;

import com.xdja.ca.pkcs7.Pkcs7Utils;
import com.xdja.ca.utils.RFC4519StyleUpperCase;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.pkcs7.SignedAndEnvelopedData;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.openapi.core.handler.IScepMessageHandler;
import com.xdja.pki.ra.openapi.core.scep.CertRepUtils;
import com.xdja.pki.ra.openapi.scep.common.IssuerAndSubject;
import com.xdja.pki.ra.service.manager.scep.ScepCertService;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="getCertInitScepMessageHandler")
public class GetCertInitScepMessageHandler
implements IScepMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ScepCertService scepCertService;

    public Result handleMessage(byte[] sourceData, byte[] transactionId, byte[] senderNonce, X509Certificate selfCert) {
        Result result = new Result();
        this.logger.info("SCEP\u8f6e\u8be2\u67e5\u8be2\u6ce8\u518c\u8bf7\u6c42\u6d88\u606f\u5904\u7406\u7c7b\u63a5\u6536\u5230\u7684\u660e\u6587\u8bf7\u6c42\u6570\u636e:{} \u4e8b\u52a1id:{}", (Object)Base64.toBase64String((byte[])sourceData), (Object)Base64.toBase64String((byte[])transactionId));
        try {
            IssuerAndSubject issuerAndSubject = IssuerAndSubject.getInstance(sourceData);
            this.logger.info("\u670d\u52a1\u7aef\u89e3\u6790\u83b7\u53d6\u5ba2\u6237\u7aef\u7684\u5bfb\u8f6e\u67e5\u8be2\u8bf7\u6c42\u5bf9\u8c61=== issuer:{} subject:{}", (Object)issuerAndSubject.getIssuerName(), (Object)issuerAndSubject.getSubjectName());
            X500Name issuerName = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)issuerAndSubject.getIssuerName());
            String issuerDn = SdkP10Utils.reverseDnSeq((X500Name)issuerName);
            X500Name subjectName = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)issuerAndSubject.getSubjectName());
            String subjectDn = SdkP10Utils.reverseDnSeq((X500Name)subjectName);
            result = this.scepCertService.pollScepCert(Base64.toBase64String((byte[])transactionId), subjectDn, issuerDn);
            SignedData repSignedData = null;
            X509Certificate serviceCert = CommonVariable.getRaServiceCert();
            if (result.isSuccess() && result.getInfo() != null) {
                UserCertInfo userCertInfo = (UserCertInfo)result.getInfo();
                String signCert = userCertInfo.getSignCert();
                X509Certificate sign = CertUtils.getCertFromStr((String)signCert);
                X509Certificate enc = null;
                SignedAndEnvelopedData signedAndEnvelopedData = null;
                if (null != userCertInfo.getEncCert()) {
                    String encCert = userCertInfo.getEncCert();
                    String encPrivateKey = userCertInfo.getEncPriKey();
                    enc = CertUtils.getCertFromStr((String)encCert);
                    signedAndEnvelopedData = SignedAndEnvelopedData.getInstance((Object)Base64.decode((String)encPrivateKey));
                }
                String extraCertsP7b = userCertInfo.getExtraCertsP7b();
                List x509Certificates = Pkcs7Utils.resolveCertChain((String)extraCertsP7b);
                SignedData sourceRepSignedData = CertRepUtils.createSourceRepSignedData((X509Certificate)sign, (X509Certificate)enc, (SignedAndEnvelopedData)signedAndEnvelopedData, null, null, (List)x509Certificates);
                ContentInfo sourceContentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sourceRepSignedData);
                repSignedData = CertRepUtils.createRepSignedData((byte[])sourceContentInfo.getEncoded("DER"), (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"0", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else if (result.isSuccess() && result.getInfo() == null) {
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"3", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else {
                int failInfoByErrorCode = CertRepUtils.getFailInfoByErrorCode((int)result.getErrorBean().getErrCode());
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"2", (byte[])senderNonce, (X509Certificate)selfCert, (Integer)failInfoByErrorCode);
            }
            ContentInfo contentInfo = CertRepUtils.createContentInfo((ASN1ObjectIdentifier)PKCSObjectIdentifiers.signedData, (ASN1Encodable)repSignedData);
            result.setContentType("application/x-pki-message");
            result.setInfo((Object)contentInfo);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CREATE_CERT_REP_STRUCTURE_EXCEPTION);
            return result;
        }
    }
}

