/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.handler;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.openapi.core.handler.IScepMessageHandler;
import com.xdja.pki.ra.openapi.core.scep.CertRepUtils;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="getCrlScepMessageHandler")
public class GetCrlScepMessageHandler
implements IScepMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Result handleMessage(byte[] sourceData, byte[] transactionId, byte[] senderNonce, X509Certificate selfCert) {
        this.logger.info("SCEP\u83b7\u53d6CRL\u6d88\u606f\u5904\u7406\u7c7b\u63a5\u6536\u5230\u7684\u660e\u6587\u8bf7\u6c42\u6570\u636e::" + Base64.toBase64String((byte[])sourceData));
        Result result = new Result();
        result.setInfo((Object)new Date());
        try {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)sourceData);
            this.logger.info("\u670d\u52a1\u7aef\u89e3\u6790\u83b7\u53d6\u5ba2\u6237\u7aef\u7684CRL\u8bf7\u6c42\u5bf9\u8c61\uff1a" + Base64.toBase64String((byte[])issuerAndSerialNumber.getEncoded()));
            SignedData repSignedData = null;
            X509Certificate serviceCert = CommonVariable.getRaServiceCert();
            if (result.isSuccess() && result.getInfo() != null) {
                SignedData sourceRepSignedData = CertRepUtils.createSourceRepSignedData(null, null, null, null, null);
                ContentInfo sourceContentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sourceRepSignedData);
                repSignedData = CertRepUtils.createRepSignedData((byte[])sourceContentInfo.getEncoded("DER"), (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"0", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else {
                String failInfo = "";
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"2", (byte[])senderNonce, (X509Certificate)selfCert, null);
            }
            ContentInfo contentInfo = CertRepUtils.createContentInfo((ASN1ObjectIdentifier)PKCSObjectIdentifiers.signedData, (ASN1Encodable)repSignedData);
            result.setContentType("application/x-pki-message");
            result.setInfo((Object)contentInfo);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CREATE_CERT_REP_STRUCTURE_EXCEPTION);
            return result;
        }
    }
}

