/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.tbox.api;

import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.service.CaSdkRedisCacheManagerService;
import com.xdja.ca.service.impl.CaSdkRedisCacheManagerServiceImpl;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.BaseCMPInfo;
import com.xdja.pki.ra.openapi.tbox.api.TBoxDeviceInfo;
import com.xdja.pki.ra.openapi.tbox.common.TboxDeviceType;
import com.xdja.pki.ra.service.manager.tbox.TboxDeviceService;
import java.security.SecureRandom;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

@RestController
public class TboxDeviceController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    TboxDeviceService tboxDeviceService;
    @Autowired
    private Pool<Jedis> jedisPool;
    private CaSdkRedisCacheManagerService caSdkRedisCacheManagerService;

    @Value(value="${transId.cache.expireTime}")
    private void init(int transIdExpireTime) {
        RedisClient redisClient = new RedisClient(this.jedisPool);
        this.caSdkRedisCacheManagerService = new CaSdkRedisCacheManagerServiceImpl(redisClient, transIdExpireTime);
    }

    @RequestMapping(value={"/v1/tbox/regist/device"}, method={RequestMethod.POST})
    public Object registerDeviceUser(@Valid @RequestBody TBoxDeviceInfo tBoxDeviceInfo, BindingResult bindResult, HttpServletResponse resp) {
        this.logger.info("TboxDeviceController.registerDeviceUser>>>>>>tBoxDeviceInfo:" + JsonUtils.object2Json((Object)tBoxDeviceInfo));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u8bbe\u5907\u53d1\u8d77\u6ce8\u518c\u8bf7\u6c42\u65f6\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        int deviceType = tBoxDeviceInfo.getDeviceType();
        if (deviceType != TboxDeviceType.MOBILE_2.value && deviceType != TboxDeviceType.TBOX_5.value && deviceType != TboxDeviceType.CAR_MACHINE_6.value) {
            return ErrorEnum.TBOX_DEVICE_TYPE_IS_ERROR.resp(resp);
        }
        Result result = null;
        try {
            result = this.tboxDeviceService.registerTboxDeviceUser(tBoxDeviceInfo.getDeviceNo(), deviceType, tBoxDeviceInfo.getDeviceName(), tBoxDeviceInfo.getDeviceDesc());
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u5907\u53d1\u8d77\u6ce8\u518c\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("TboxDeviceController.registerDeviceUser>>>>>>result:" + JsonUtils.object2Json((Object)result.getInfo()));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/tbox/ra/random"}, method={RequestMethod.GET})
    public Object genRandomNum(@RequestParam String transId, HttpServletResponse resp) {
        this.logger.info("TboxDeviceController.genRandomNum>>>>>>transId:" + transId);
        if (StringUtils.isBlank((CharSequence)transId)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        byte[] raRecipNonce = new byte[16];
        raRecipNonce = TboxDeviceController.genRandomByHsm(raRecipNonce.length);
        BaseCMPInfo baseCMPInfo = new BaseCMPInfo(null, raRecipNonce, transId, -1L, 0, null);
        this.caSdkRedisCacheManagerService.cacheCaSdkCmpInfo(transId, JsonUtils.object2Json((Object)baseCMPInfo));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CASDK put transId:[{}] baseCMPInfo:[{}]", (Object)transId, (Object)JsonUtils.object2Json((Object)baseCMPInfo));
        }
        return Base64.toBase64String((byte[])raRecipNonce);
    }

    public static byte[] genRandomByHsm(int length) {
        byte[] normalSenderNonce = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(normalSenderNonce);
        return normalSenderNonce;
    }
}

