/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.tbox.cmp.handler;

import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.UserCertDao;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.certapply.RevokeApplyService;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.RevDetails;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="cmpRecoveryCertReqHandler")
public class CmpRevokeReqHandler
implements ICmpMessageHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RevokeApplyService revokeApplyService;
    @Autowired
    UserCertDao userCertDao;
    @Autowired
    private Environment env;

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage revokeMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (revokeMessage == null) {
            String errMsg = "RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        PKIHeader header = revokeMessage.getHeader();
        if (header == null) {
            String errMsg = "RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = GeneralName.getInstance((Object)header.getSender());
        GeneralName recipient = header.getRecipient();
        byte[] tboxRecipNonce = new byte[]{};
        byte[] tboxSenderNonce = new byte[]{};
        String tboxTranID = null;
        AlgorithmIdentifier protectionAlg = null;
        try {
            tboxRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            tboxSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            tboxTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (tboxRecipNonce == null || tboxSenderNonce == null || protectionAlg == null || StringUtils.isBlank((CharSequence)tboxTranID)) {
            String errMsg = "RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== \u64a4\u9500\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        DERBitString protectData = revokeMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        X509Certificate cert = null;
        try {
            CMPCertificate[] extraCerts = revokeMessage.getExtraCerts();
            cert = SdkCertUtils.convertDerCertToCert((byte[])extraCerts[0].getEncoded());
        }
        catch (Exception e) {
            this.logger.error("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== \u6d88\u606f\u4f53\u4e2d\u672a\u5305\u542b\u9a8c\u8bc1\u8bc1\u4e66");
            result.setError(ErrorEnum.THE_PKIMESSAGE_HEADER_NO_EXTRACERTS);
            return result;
        }
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)cert.getPublicKey(), (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, null);
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 3.1 \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0:{}", (Object)JsonUtils.object2Json((Object)checkResult));
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)checkResult.getError().code, (String)checkResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PKIBody body = revokeMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.code, (String)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (body.getType() != 11) {
            this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f11");
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.REVOKED_CERT_PKI_BODY_TAG_NOT_11.code, (String)ErrorEnum.REVOKED_CERT_PKI_BODY_TAG_NOT_11.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        RevReqContent myRevReqContent = (RevReqContent)body.getContent();
        if (myRevReqContent == null) {
            this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4e2dRevReqContent\u4e3a\u7a7a");
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.PKI_BODY_REV_REQ_CONTENT_IS_EMPTY.code, (String)ErrorEnum.PKI_BODY_REV_REQ_CONTENT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        RevDetails[] revDetails = myRevReqContent.toRevDetailsArray();
        CertTemplate certDetail = revDetails[0].getCertDetails();
        ASN1Integer serialNumber = certDetail.getSerialNumber();
        String signSnDecimal = serialNumber.getValue().toString(16).toLowerCase();
        String deviceNo = header.getSender().getName().toString();
        int size = this.userCertDao.getUserIsHave(signSnDecimal);
        if (size != 1) {
            result.setError(ErrorEnum.ONLINE_DEVICE_INFO_NOT_EXIST);
            return result;
        }
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 4. \u53d1\u8d77\u64a4\u9500\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42");
        RevokeApplyDTO revokeApplyDTO = new RevokeApplyDTO();
        revokeApplyDTO.setSignSn(signSnDecimal);
        String tboxTemplateNo = null;
        try {
            tboxTemplateNo = this.env.getProperty("tbox.cert.template.no");
        }
        catch (Exception e) {
            result.setError(ErrorEnum.GET_TBOX_TEMPLATE_EXCEPTION);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)tboxTemplateNo)) {
            result.setError(ErrorEnum.TBOX_TEMPLATE_NO_NOT_EXIST);
            return result;
        }
        revokeApplyDTO.setTempNo(tboxTemplateNo);
        revokeApplyDTO.setRevokeReason(Integer.valueOf(0));
        revokeApplyDTO.setApplyReason("Tbox\u53d1\u8d77\u5728\u7ebf\u64a4\u9500\u8bc1\u4e66\u8bf7\u6c42");
        revokeApplyDTO.setLicenseNumber(deviceNo);
        Result revokeResult = this.revokeApplyService.insertUserCertRevokeApply(null, revokeApplyDTO, true, false);
        if (!revokeResult.isSuccess()) {
            this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 4.1. \u64a4\u9500\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42\u9519\u8bef:{}", (Object)JsonUtils.object2Json((Object)revokeResult));
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)revokeResult.getError().code, (String)revokeResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== RA\u8fd4\u56de\u7684\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42\u7684\u54cd\u5e94\u7ed3\u679c>>>>>>>:{}", (Object)JsonUtils.object2Json((Object)revokeResult));
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 5. \u5c01\u88c5CertRepMessage\u7ed3\u6784\u4f53");
        RevRepContent revRepContent = PKIMessageHelper.genRevRepContent();
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== 6. \u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage repPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)12, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)revRepContent);
        result.setInfo((Object)repPkiMessage);
        this.logger.info("RA\u64a4\u9500\u7533\u8bf7\u5904\u7406 ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }
}

