/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.schedule;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.dao.MonitorCpuDao;
import com.xdja.pki.monitor.dao.model.MonitorCpuDO;
import com.xdja.pki.monitor.service.MonitorService;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@Configurable
@EnableScheduling
public class ScheduledTasks {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MonitorService monitorService;
    @Resource
    private MonitorCpuDao monitorCpuDao;

    public void reportCurrentTime() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scheduling Tasks Examples: The time is now :{}", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date()));
        }
    }

    public void reportCurrentByCron() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scheduling Tasks Examples By Cron: The time is now :{}", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date()));
        }
    }

    public void monitorCpuForQuarter() {
        CoreResult result;
        long current = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u542f\u52a8CPU\u5229\u7528\u7387\u76d1\u63a7\u7ebf\u7a0b\uff01");
        }
        if ((result = this.monitorService.monitorCpu()).getInfo() != null) {
            CpuData cpuData = (CpuData)result.getInfo();
            this.monitorCpuDao.insertMonitorCpuData(new MonitorCpuDO(BigDecimal.valueOf(cpuData.getUsage()).setScale(5, 4), new Timestamp(current)));
        }
    }
}

