package com.xdja.ra.utils;

import com.alibaba.fastjson.JSON;
import com.xdja.pki.gmssl.http.GMSSLHttpClient;
import com.xdja.pki.gmssl.http.GMSSLHttpsClient;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import com.xdja.ra.bean.ErrorMsg;
import com.xdja.ra.bean.Result;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.ennum.ReqMethodEnum;
import com.xdja.ra.error.ErrorBean;
import com.xdja.ra.error.ErrorEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.cert.X509Certificate;
import java.util.Map;

/**
 * https通道
 *
 * @author wly
 */
public class GMSSLHttpReqUtils {

    protected static transient final Logger logger = LoggerFactory.getLogger(GMSSLHttpReqUtils.class);

    public static Result sendGMSSLHttpReq(String method, String url, boolean isHttps, X509Certificate[] caCert, Map<String,String> header, byte[] reqBody, Map<String, String> params) {
        GMSSLHttpClient httpClient = null;
        if (isHttps) {
            if (caCert != null) {
                try {
                    httpClient = new GMSSLHttpsClient(caCert);
                } catch (GMSSLHttpException e) {
                    logger.error(method + "请求 ========== 国密安全通道工具类异常{}", e);
                    return Result.failure(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
                }
            } else {
                httpClient = new GMSSLHttpsClient();
            }
            url = "https://" + url;
        } else {
            httpClient = new GMSSLHttpClient();
            url = "http://" + url;
        }

        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        if (null != params) {
            request.setParams(params);
        }
        request.setHeaders(header);
        if (null != reqBody) {
            request.setBody(reqBody);
        }
        GMSSLHttpResponse response;
        try {
            response = getGMSSLHttpResponse(httpClient, request, method);
        } catch (Exception e) {
            logger.error(method + "请求 ========== 国密安全通道工具类异常{}", e);
            return Result.failure(ErrorEnum.GMSSL_HTTP_CLIENT_INTER_EXCEPTION);
        }

        logger.debug("========== sendGMSSLHttpReq.result>>>>" + response.getStatusCode() + " " + new String(response.getBody()));
        if (response.getStatusCode() != SdkConstants.SUCCESS_CODE_200) {
            if (null == response.getBody()){
                logger.error(" ========== 请求RA的外部接口返回信息为空");
                return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_INFO_IS_EMPTY);
            }
            try {
                ErrorBean errorBean = SdkJsonUtils.json2Object(new String(response.getBody()), ErrorBean.class);
                ErrorMsg errorMsg;
                if (null == errorBean.getErrMsg()) {
                    errorMsg = JSON.parseObject(new String(response.getBody()), ErrorMsg.class);
                    return Result.failure(errorMsg.getErrorCode(), errorMsg.getErrorMsg());
                } else {
                    return Result.failure(errorBean.getErrCode(), errorBean.getErrMsg());
                }

            } catch (Exception e) {
                logger.error(" ========== 请求RA的外部接口异常信息:{}", e);
                return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_EXCEPTION);
            }
        }
        byte[] resp = response.getBody();
        return Result.success(resp);

    }

    private static GMSSLHttpResponse getGMSSLHttpResponse(GMSSLHttpClient httpClient, GMSSLHttpRequest request, String method) throws GMSSLHttpException {
        if (method.equals(ReqMethodEnum.GET.name)) {
            return httpClient.get(request);
        }
        if (method.equals(ReqMethodEnum.POST.name)) {
            return httpClient.post(request);
        }
        if (method.equals(ReqMethodEnum.PUT.name)) {
            return httpClient.put(request);
        }
        if (method.equals(ReqMethodEnum.DELETE.name)) {
            return httpClient.delete(request);
        }
        throw new RuntimeException("不支持的请求方法");
    }
}
