/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(FileUtils.class.getClass());

    public static String read(String path) throws Exception {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = null;
        try {
            File file = new File(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String temp;
            reader = new BufferedReader(new FileReader(new File(path)));
            while (null != (temp = reader.readLine())) {
                content.append(temp);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u6587\u4ef6\u65f6\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static String readByBytes(String path) {
        String content = null;
        try {
            FileInputStream inputStream = new FileInputStream(path);
            StringBuffer sb = new StringBuffer();
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                sb.append(new String(bytes, 0, c, "utf-8"));
            }
            content = sb.toString();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u5b57\u8282\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Object)e.getMessage());
        }
        return content;
    }

    public static String readByLines(String path) {
        String content = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String temp = null;
            while ((temp = bufferedReader.readLine()) != null) {
                sb.append(temp);
            }
            content = sb.toString();
            bufferedReader.close();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Object)e.getMessage());
            throw new RuntimeException("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38" + e.getMessage(), e);
        }
        return content;
    }

    public static String readByChars(String path) {
        String content = null;
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), "utf-8");
            StringBuffer sb = new StringBuffer();
            char[] tempchars = new char[1024];
            while (reader.read(tempchars) != -1) {
                sb.append(tempchars);
            }
            content = sb.toString();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Object)e.getMessage());
            throw new RuntimeException(" \u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38" + e.getMessage(), e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        try {
            if (!file.exists()) {
                mkdir = file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5931\u8d25", e);
        }
        OutputStreamWriter fw = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileWriter(new File(path), false);
                if (content != null) {
                    fw.write(content);
                }
                fw.flush();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Object)e.getMessage());
            throw new RuntimeException("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38" + e.getMessage(), e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(byte[] content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        OutputStream out = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                out = new FileOutputStream(new File(path), false);
                ByteArrayInputStream is = new ByteArrayInputStream(content);
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = is.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
                ((InputStream)is).close();
                out.close();
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Object)e.getMessage());
            throw new RuntimeException("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38" + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        {
            return;
        }
    }

    public static String downloadFile(String fileFullPath, byte[] fileInfo) {
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.exists()) {
                file.delete();
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            file.createNewFile();
            FileOutputStream fileWriter = new FileOutputStream(file);
            fileWriter.write(fileInfo);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", (Object)e.getMessage());
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38" + e.getMessage(), e);
        }
        return fileFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveCertInfoFile(String fileFullPath, String fileInfo, boolean isClearDir) {
        OutputStreamWriter fw = null;
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.getParentFile().exists() && isClearDir) {
                FileUtils.deleteFile(file.getParentFile());
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileWriter(new File(fileFullPath), false);
                if (fileInfo != null) {
                    fw.write(fileInfo);
                }
                fw.flush();
                // ** MonitorExit[var5_8] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", (Object)e.getMessage());
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38" + e.getMessage(), e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        {
            return fileFullPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveByteCertInfoFile(String fileFullPath, byte[] fileInfo, boolean isClearDir) {
        FileOutputStream fw = null;
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.getParentFile().exists() && isClearDir) {
                FileUtils.deleteFile(file.getParentFile());
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileOutputStream(new File(fileFullPath), false);
                if (fileInfo != null) {
                    fw.write(fileInfo);
                }
                fw.flush();
                // ** MonitorExit[var5_8] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", (Object)e.getMessage());
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38" + e.getMessage(), e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        {
            return fileFullPath;
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                File[] listFiles;
                for (File file2 : listFiles = file.listFiles()) {
                    FileUtils.deleteFile(file2);
                }
            }
            file.delete();
        } else {
            System.out.println("\u8be5file\u8def\u5f84\u4e0d\u5b58\u5728\uff01\uff01");
        }
    }

    public static byte[] readByBinary(String path) {
        FileInputStream inputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(path);
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                baos.write(bytes, 0, c);
            }
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38" + e.getMessage(), e);
        }
        return baos.toByteArray();
    }

    public static void writeByBinary(String path, byte[] datas) throws IOException {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(path);
        ((OutputStream)os).write(datas);
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out, File file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[1024];
            int size = 0;
            while ((size = ((InputStream)in).read(data)) != -1) {
                out.write(data, 0, size);
            }
        }
        finally {
            if (null != in) {
                ((InputStream)in).close();
            }
        }
    }

    public static byte[] readToBytes(InputStream in) throws Exception {
        int num;
        ByteArrayOutputStream outputData = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((num = in.read(buf)) != -1) {
            outputData.write(buf, 0, num);
        }
        return outputData.toByteArray();
    }

    public static boolean newPath(String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdir())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        return true;
    }

    public static void main(String[] args) {
        FileUtils.newPath("D:/home/xdja/conf/ra/caCerts/");
    }
}

