/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.ra.bean.Result;
import com.xdja.ra.utils.CertUtils;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreUtils {
    public static void main(String[] args) {
        try {
            Certificate certificate = KeyStoreUtils.getPublicKeyFromP12(null, "D:\\home\\xdja\\conf\\ra-sdk\\SignCert_08z6227x.p12", "SignCert_08z6227x");
            System.out.println(certificate);
            String certPem = CertUtils.writeObject(certificate);
            System.out.println(certPem);
            PublicKey publicKey = certificate.getPublicKey();
            Result result = new Result();
            result.setInfo(publicKey);
            PublicKey publicKey1 = (PublicKey)result.getInfo();
            System.out.println(publicKey1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Certificate getPublicKeyFromP12(String alias, String pkikeyPath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12", (Provider)new BouncyCastleProvider());
        keyStore.load(new FileInputStream(pkikeyPath), keyStorePwd.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String alias1 = null;
        List<Certificate> list = null;
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
            Certificate[] certificates = keyStore.getCertificateChain(alias1);
            if (null == certificates) continue;
            list = new ArrayList<Certificate>(Arrays.asList(certificates));
            list = KeyStoreUtils.sortCerts(list);
            return list.get(0);
        }
        throw new RuntimeException("\u89e3\u6790pfx\u8bc1\u4e66\u6587\u4ef6\u5931\u8d25");
    }

    public static List sortCerts(List certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        if (retList.size() > 1) {
            return orig;
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static PrivateKey getPriKeyByAliasFromP12(String alias, String saveFilePath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12", (Provider)new BouncyCastleProvider());
        keyStore.load(new FileInputStream(saveFilePath), keyStorePwd.toCharArray());
        String alias1 = null;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias1, keyStorePwd.toCharArray());
        return privateKey;
    }
}

