/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;
import java.security.PublicKey;

public class SdkBCUtils {
    public static boolean verifyCertByBC(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        if (SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        }
        return verifyResult;
    }
}

