/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.sdk;

import com.alibaba.fastjson.JSON;
import com.xdja.ra.bean.ApplyRep;
import com.xdja.ra.bean.CertApplyInfo;
import com.xdja.ra.bean.CertBaseInfo;
import com.xdja.ra.bean.CheckApply;
import com.xdja.ra.bean.Config;
import com.xdja.ra.bean.DoubleCode;
import com.xdja.ra.bean.EditCertApplyInfo;
import com.xdja.ra.bean.ErrorMsg;
import com.xdja.ra.bean.IssueApply;
import com.xdja.ra.bean.Result;
import com.xdja.ra.bean.RevokeApply;
import com.xdja.ra.bean.TemplateInfo;
import com.xdja.ra.bean.UpdateApply;
import com.xdja.ra.bean.UserCertInfo;
import com.xdja.ra.bean.UserCertReq;
import com.xdja.ra.bean.UserInfo;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.ennum.ReqMethodEnum;
import com.xdja.ra.ennum.SignatureAlgorithmEnum;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.sdk.RaCmpApi;
import com.xdja.ra.utils.ConfigUtils;
import com.xdja.ra.utils.FileUtils;
import com.xdja.ra.utils.GMSSLHttpReqUtils;
import com.xdja.ra.utils.KeyStoreUtils;
import com.xdja.ra.utils.SdkJsonUtils;
import com.xdja.ra.utils.SignUtils;
import com.xdja.ra.utils.SignedDataUtils;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static SDKService sdkService;
    public static Config config;

    public static SDKService getInstance() {
        return sdkService;
    }

    public SDKService() {
    }

    public SDKService(Config config) {
    }

    public void init() {
        try {
            config = ConfigUtils.getConfig();
            String baseUrl = config.getServerIp() + ":" + config.getServerPort() + "/ra-web";
            config.setRaBaseUrl(baseUrl);
            X509Certificate cert = (X509Certificate)KeyStoreUtils.getPublicKeyFromP12(null, config.getPrikeyPath(), config.getPriKeyPwd());
            config.setSystemCert(cert);
            config.setUserCertSn(cert.getSerialNumber().toString(16));
            config.setCertSignAlgOid(cert.getSigAlgOID());
            if (null == cert.getSigAlgName()) {
                config.setSignName(SignatureAlgorithmEnum.getName(config.getCertSignAlgOid()));
            } else {
                config.setSignName(cert.getSigAlgName());
            }
            String trustCertP7b = FileUtils.read(config.getTrustCertPath());
            byte[] base64Bytes = Base64.decode((String)trustCertP7b);
            List<X509Certificate> certs = SignedDataUtils.resolveCertChain(base64Bytes);
            X509Certificate[] caCerts = new X509Certificate[certs.size()];
            for (int i = 0; i < certs.size(); ++i) {
                caCerts[i] = certs.get(i);
            }
            config.setTrustCert(caCerts);
            PrivateKey privateKey = SignUtils.getPrivateKeyFromP12(config.getPrikeyPath(), config.getPriKeyPwd().toCharArray());
            config.setPrivateKey(privateKey);
            sdkService = new SDKService(config);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316SDKService\u5f02\u5e38", (Throwable)e);
        }
    }

    public SDKService(String serverIp, String serverPort, String prikeyPath, String prikeyPwd, String trustCertPath, String systemFlag) {
        try {
            ConfigUtils.setServerIp(serverIp);
            ConfigUtils.setServerPort(serverPort);
            ConfigUtils.setPriKeyPath(prikeyPath);
            ConfigUtils.setPriKeyPwd(prikeyPwd);
            ConfigUtils.setTrustCertPath(trustCertPath);
            ConfigUtils.setSystemFlag(systemFlag);
            this.init();
            SignUtils.sign(config.getSignName(), config.getPrivateKey(), "init");
            JSON.toJSONString((Object)new UserInfo());
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316SDK\u5931\u8d25", e);
        }
    }

    public Result userRegist(Integer userType, UserInfo userInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + userType;
            String source = reqUrl + JSON.toJSONString((Object)userInfo);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.POST.name, JSON.toJSONString((Object)userInfo));
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userQuery(Integer userType, Integer identType, String identNumber) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                UserInfo userInfo = (UserInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), UserInfo.class);
                result.setInfo(userInfo);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userUpdate(Integer userType, Integer identType, String identNumber, UserInfo userInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber;
            String source = reqUrl + JSON.toJSONString((Object)userInfo);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)userInfo));
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userStatusUpdate(Integer userType, Integer identType, String identNumber, Integer userStatus) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber + "/" + userStatus;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, null);
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getRASystemBaseDn() {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/baseDn";
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                result.setInfo(new String((byte[])result.getInfo()));
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getTemplateInfoList(String systemFlag) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/template/" + systemFlag;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                List templateInfoList = JSON.parseArray((String)new String((byte[])result.getInfo()), TemplateInfo.class);
                result.setInfo(templateInfoList);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startIssueUserCertApply(IssueApply issueApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/issue";
            return this.getApplyResult(JSON.toJSONString((Object)issueApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startUpdateUserCertApply(UpdateApply updateApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/update";
            return this.getApplyResult(JSON.toJSONString((Object)updateApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startRevokeUserCertApply(RevokeApply revokeApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/revoke";
            return this.getApplyResult(JSON.toJSONString((Object)revokeApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result checkUserCertApply(Integer applyType, String applyNo, CheckApply checkApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/check/" + applyType + "/" + applyNo;
            String source = reqUrl + JSON.toJSONString((Object)checkApply);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)checkApply));
            if (result.isSuccess().booleanValue()) {
                DoubleCode doubleCode = (DoubleCode)JSON.parseObject((String)new String((byte[])result.getInfo()), DoubleCode.class);
                result.setInfo(doubleCode);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result generateUserCert(Integer applyType, String applyNo, UserCertReq userCertReq) {
        Result sdkResult;
        Result result = new Result();
        if (applyType == null || userCertReq == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{applyNo, userCertReq.getAuthCode(), userCertReq.getRefCode()})) {
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        if (applyType != SdkConstants.CERT_APPLY_TYPE_ISSUE_1 && applyType != SdkConstants.CERT_APPLY_TYPE_UPDATE_2) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String transId = UUID.randomUUID().toString().replace("-", "");
        RaCmpApi raCmpApi = new RaCmpApi();
        try {
            sdkResult = raCmpApi.sendCertReqMessage(applyType, transId, config.getSystemFlag(), config.getCertSignAlgOid(), applyNo, userCertReq);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        this.logger.debug("SDKService.generateUserCert.result:" + SdkJsonUtils.object2Json(sdkResult.getInfo()));
        return this.getCmpResult(result, sdkResult);
    }

    public Result certApplyConfirmMsg(String applyNo) {
        Result sdkResult;
        Result result = new Result();
        RaCmpApi raCmpApi = new RaCmpApi();
        try {
            sdkResult = raCmpApi.sendConfirmMessage(config.getCertSignAlgOid(), config.getSystemFlag(), applyNo);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        return this.getCmpResult(result, sdkResult);
    }

    public Result certApplyErrorMsg(String applyNo, ErrorMsg errorMsg) {
        Result sdkResult;
        Result result = new Result();
        RaCmpApi raCmpApi = new RaCmpApi();
        try {
            sdkResult = raCmpApi.sendErrorMessage(applyNo, config.getCertSignAlgOid(), config.getSystemFlag(), errorMsg.getErrorMsg(), errorMsg.getErrorCode());
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        return this.getCmpResult(result, sdkResult);
    }

    private Result getCmpResult(Result result, Result sdkResult) {
        if (!sdkResult.isSuccess().booleanValue()) {
            if (SdkConstants.ERROR_CODE_110.equals(String.valueOf(sdkResult.getErrorMsg().getErrorCode()).substring(0, 3))) {
                return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
            }
            result.setErrorMsg(sdkResult.getErrorMsg());
            return result;
        }
        return Result.success(sdkResult.getInfo());
    }

    public Result certApplyQuery(Integer applyType, String applyNo) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/" + applyType + "/" + applyNo;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                CertApplyInfo certApplyInfo = (CertApplyInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), CertApplyInfo.class);
                result.setInfo(certApplyInfo);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result certApplyUpdate(Integer applyType, String applyNo, EditCertApplyInfo editCertApplyInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/" + applyType + "/" + applyNo;
            String source = reqUrl + JSON.toJSONString((Object)editCertApplyInfo);
            return this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)editCertApplyInfo));
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userCertQuery(Integer userType, Integer identType, String identNumber) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/" + userType + "/" + identType + "/" + identNumber;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                List userCertInfoList = JSON.parseArray((String)new String((byte[])result.getInfo()), UserCertInfo.class);
                result.setInfo(userCertInfoList);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userCertDetailQuery(String certSn) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/" + certSn;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue()) {
                CertBaseInfo certBaseInfo = (CertBaseInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), CertBaseInfo.class);
                result.setInfo(certBaseInfo);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result userCertDownload(String certSn) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/file/" + certSn;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (!result.isSuccess().booleanValue()) {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isHostConnectivity(String host, int port) {
        block10: {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port));
            try {
                socket.close();
            }
            catch (Exception e) {
                this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e});
            }
            break block10;
            catch (Exception e) {
                boolean bl;
                try {
                    this.logger.debug("isHostConnectivity socket connect {}:{} error", new Object[]{host, port, e});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (Exception e2) {
                        this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e2});
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (Exception e3) {
                    this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e3});
                }
                return bl;
            }
        }
        return true;
    }

    private Result buildData(String reqUrl, String source, String methodName, String reqBody) throws Exception {
        String url = config.getRaBaseUrl() + reqUrl;
        String sourceData = Base64.toBase64String((byte[])URLDecoder.decode(source, "UTF-8").getBytes("utf-8"));
        String sign = SignUtils.sign(config.getSignName(), config.getPrivateKey(), sourceData);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json; charset=UTF-8");
        header.put("systemFlag", config.getSystemFlag());
        header.put("timestamp", String.valueOf(System.currentTimeMillis()));
        header.put("signAlg", config.getSignName());
        header.put("signValue", sign);
        header.put("signSn", config.getUserCertSn());
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570sign[{}]", (Object)sign);
        this.logger.debug("source:[{}]", (Object)sourceData);
        if (null == reqBody) {
            reqBody = "";
        }
        Result result = GMSSLHttpReqUtils.sendGMSSLHttpReq(methodName, url, true, config.getTrustCert(), header, reqBody.getBytes(), null);
        return result;
    }

    private Result getApplyResult(String applyReq, String reqUrl) throws Exception {
        String source = reqUrl + applyReq;
        Result result = this.buildData(reqUrl, source, ReqMethodEnum.POST.name, applyReq);
        if (result.isSuccess().booleanValue()) {
            ApplyRep applyRep = (ApplyRep)JSON.parseObject((String)new String((byte[])result.getInfo()), ApplyRep.class);
            result.setInfo(applyRep);
        } else {
            result.setInfo(null);
        }
        return result;
    }
}

