/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class SdkP10Utils {
    private static String unFormatP10(String pemP10) {
        String p10Value = null;
        String P10_HEAD = "-----BEGIN CERTIFICATE REQUEST-----";
        String P10_TAIL = "-----END CERTIFICATE REQUEST-----";
        pemP10 = pemP10.replace(P10_HEAD, "");
        pemP10 = pemP10.replace(P10_TAIL, "");
        pemP10 = pemP10.replace("\r", "");
        p10Value = pemP10 = pemP10.replace("\n", "");
        return p10Value;
    }

    public static boolean verifyP10Info(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String p10ToCertDn(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getCertificationRequestInfo().getSubject().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PublicKey p10ToPublicKey(String p10) {
        String p10Value = SdkP10Utils.unFormatP10(p10);
        byte[] bsCert = Base64.decode((String)p10Value);
        PKCS10CertificationRequest re = new PKCS10CertificationRequest(bsCert);
        re.getCertificationRequestInfo();
        PublicKey pk = null;
        try {
            pk = re.getPublicKey("BC");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return pk;
    }

    public static byte[] p10ToReqInfo(String p10) {
        String p10Value = SdkP10Utils.unFormatP10(p10);
        byte[] bsCert = Base64.decode((String)p10Value);
        PKCS10CertificationRequest re = new PKCS10CertificationRequest(bsCert);
        CertificationRequestInfo certificationRequestInfo = re.getCertificationRequestInfo();
        byte[] reqInfo = new byte[]{};
        try {
            reqInfo = certificationRequestInfo.getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reqInfo;
    }

    public static String p10ToSignValue(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignature().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ASN1ObjectIdentifier p10ToSignAlgo(String p10) {
        String p10Vaule = SdkP10Utils.unFormatP10(p10);
        byte[] keytemp = null;
        try {
            keytemp = Base64.decode((String)p10Vaule);
            PKCS10CertificationRequest re = new PKCS10CertificationRequest(keytemp);
            return re.getSignatureAlgorithm().getAlgorithm();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

