package com.xdja.ra.asn1;

import org.bouncycastle.asn1.*;

import java.math.BigInteger;
import java.util.Enumeration;

/**
 * GM/T 0016-2012 智能密码钥匙 -用保护公钥加密的对称密钥密文
 *
 * @author syg
 */
public class EccCipherBlob extends ASN1Object {

    private ASN1OctetString xCoordinate;
    private ASN1OctetString yCoordinate;
    private ASN1OctetString hash;
    private ASN1Integer cipherLen;
    private ASN1OctetString cipherText;

    public static EccCipherBlob getInstance(Object o) {
        if (o instanceof EccCipherBlob) {
            return (EccCipherBlob) o;
        } else if (o != null) {
            return new EccCipherBlob(ASN1Sequence.getInstance(o));
        }

        return null;
    }


    public EccCipherBlob(ASN1Sequence eccCipherBlobSequence) {
        Enumeration e = eccCipherBlobSequence.getObjects();
        xCoordinate = ASN1OctetString.getInstance(e.nextElement());
        yCoordinate = ASN1OctetString.getInstance(e.nextElement());
        hash = ASN1OctetString.getInstance(e.nextElement());
        cipherLen = ASN1Integer.getInstance(e.nextElement());
        cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public EccCipherBlob(ASN1OctetString xCoordinate, ASN1OctetString yCoordinate, ASN1OctetString hash, ASN1Integer cipherLen, ASN1OctetString cipherText) {
        super();
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.hash = hash;
        this.cipherLen = cipherLen;
        this.cipherText = cipherText;
    }

    public EccCipherBlob(byte[] x, byte[] y, byte[] hash, int cipherLen, byte[] cipherText) {
        super();
        this.xCoordinate = new DEROctetString(x);
        this.yCoordinate = new DEROctetString(y);
        if (hash == null){
            this.hash = null;
        }else {
            this.hash = new DEROctetString(hash);
        }
        this.cipherLen = new ASN1Integer(cipherLen);
        this.cipherText = new DEROctetString(cipherText);
    }

    public byte[] getxCoordinate() {
        return xCoordinate.getOctets();
    }

    public byte[] getyCoordinate() {
        return yCoordinate.getOctets();
    }

    public byte[] getHash() {
        return hash.getOctets();
    }

    public BigInteger getCipherLen() {
        return cipherLen.getValue();
    }

    public byte[] getCipherText() {
        return cipherText.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(xCoordinate);
        vector.add(yCoordinate);
        vector.add(hash);
        vector.add(cipherLen);
        vector.add(cipherText);
        return new DERSequence(vector);
    }
}
