package com.xdja.ra.asn1;

import org.bouncycastle.asn1.*;

import java.math.BigInteger;
import java.util.Enumeration;

/**
 * GM/T 0016-2012 智能密码钥匙 -加密密钥对的公钥
 *
 * @author syg
 */
public class EccPublicKeyBlob extends ASN1Object {

    private ASN1Integer bitLen;
    private ASN1OctetString xCoordinate;
    private ASN1OctetString yCoordinate;

    public static EccPublicKeyBlob getInstance(Object o) {
        if (o instanceof EccPublicKeyBlob) {
            return (EccPublicKeyBlob) o;
        } else if (o != null) {
            return new EccPublicKeyBlob(ASN1Sequence.getInstance(o));
        }

        return null;
    }


    public EccPublicKeyBlob(ASN1Sequence eccPublicKeyBlobSequence) {
        Enumeration e = eccPublicKeyBlobSequence.getObjects();
        bitLen = ASN1Integer.getInstance(e.nextElement());
        xCoordinate = ASN1OctetString.getInstance(e.nextElement());
        yCoordinate = ASN1OctetString.getInstance(e.nextElement());
    }

    public EccPublicKeyBlob(ASN1Integer bitLen, ASN1OctetString xCoordinate, ASN1OctetString yCoordinate) {
        super();
        this.bitLen = bitLen;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
    }

    public EccPublicKeyBlob(int bigLen, byte[] x, byte[] y) {
        super();
        this.bitLen = new ASN1Integer(bigLen);
        this.xCoordinate = new DEROctetString(x);
        this.yCoordinate = new DEROctetString(y);
    }

    public byte[] getxCoordinate() {
        return xCoordinate.getOctets();
    }

    public byte[] getyCoordinate() {
        return yCoordinate.getOctets();
    }


    public BigInteger getBitLen() {
        return bitLen.getValue();
    }


    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(bitLen);
        vector.add(xCoordinate);
        vector.add(yCoordinate);
        return new DERSequence(vector);
    }
}
