package com.xdja.ra.asn1;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

import java.math.BigInteger;
import java.util.Enumeration;

/**
 * GM/T 0016-2012 智能密码钥匙 -ECC加密密钥对保护结构
 *
 * @author syg
 */
public class SkfEnvelopedKeyBlob extends ASN1Object {
    private ASN1Integer version;
    private AlgorithmIdentifier ulSymmAlgID;
    private ASN1Integer ulBits;
    private ASN1OctetString cbEncryptedPriKey;
    private EccPublicKeyBlob pubKey;
    private EccCipherBlob eccCipherBlob;

    public static SkfEnvelopedKeyBlob getInstance(Object o) {
        if (o instanceof SkfEnvelopedKeyBlob) {
            return (SkfEnvelopedKeyBlob) o;
        } else if (o != null) {
            return new SkfEnvelopedKeyBlob(ASN1Sequence.getInstance(o));
        }

        return null;
    }


    public SkfEnvelopedKeyBlob(ASN1Sequence skfEnvelopedKeyBlobSequence) {
        Enumeration e = skfEnvelopedKeyBlobSequence.getObjects();
        version = ASN1Integer.getInstance(e.nextElement());
        ulSymmAlgID = AlgorithmIdentifier.getInstance(e.nextElement());
        ulBits = ASN1Integer.getInstance(e.nextElement());
        cbEncryptedPriKey = ASN1OctetString.getInstance(e.nextElement());
        pubKey = EccPublicKeyBlob.getInstance(e.nextElement());
        eccCipherBlob = EccCipherBlob.getInstance(e.nextElement());
    }

    public SkfEnvelopedKeyBlob(ASN1Integer version, AlgorithmIdentifier ulSymmAlgID, ASN1Integer ulBits, ASN1OctetString cbEncryptedPriKey, EccPublicKeyBlob eccPublicKeyBlob, EccCipherBlob eccCipherBlob) {
        super();
        this.version = version;
        this.ulSymmAlgID = ulSymmAlgID;
        this.ulBits = ulBits;
        this.cbEncryptedPriKey = cbEncryptedPriKey;
        this.pubKey = pubKey;
        this.eccCipherBlob = eccCipherBlob;
    }

    public SkfEnvelopedKeyBlob(int version, ASN1ObjectIdentifier ulSymmAlgID, int ulBits, byte[] cbEncryptedPriKey, EccPublicKeyBlob eccPublicKeyBlob, EccCipherBlob eccCipherBlob) {
        super();
        this.version = new ASN1Integer(version);
        this.ulSymmAlgID = new AlgorithmIdentifier(ulSymmAlgID);
        this.ulBits = new ASN1Integer(ulBits);
        this.cbEncryptedPriKey = new DEROctetString(cbEncryptedPriKey);
        this.pubKey = eccPublicKeyBlob;
        this.eccCipherBlob = eccCipherBlob;
    }

    public BigInteger getVersion() {
        return version.getValue();
    }

    public ASN1ObjectIdentifier getUlSymmAlgID() {
        return ulSymmAlgID.getAlgorithm();
    }

    public BigInteger getUlBits() {
        return ulBits.getValue();
    }

    public byte[] getCbEncryptedPriKey() {
        return cbEncryptedPriKey.getOctets();
    }

    public EccPublicKeyBlob getPubKey() {
        return pubKey;
    }

    public EccCipherBlob getEccCipherBlob() {
        return eccCipherBlob;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(version);
        vector.add(ulSymmAlgID);
        vector.add(ulBits);
        vector.add(cbEncryptedPriKey);
        vector.add(pubKey);
        vector.add(eccCipherBlob);
        return new DERSequence(vector);
    }


}
