package com.xdja.ra.utils;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.security.auth.x500.X500Principal;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;


/**
 * 处理jks文件工具类
 *
 * @author syg
 */
public class KeyStoreUtils {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
    /**
     * 读取JKS文件获取证书
     *
     * @param pkikeyPath
     * @param keyStorePwd
     * @return
     * @throws Exception
     */
    public static Certificate getCertFromBKS(String pkikeyPath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("BKS",new BouncyCastleProvider());
        keyStore.load(new FileInputStream(pkikeyPath), keyStorePwd.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String alias1 = null;
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
        }
        Certificate certificate = keyStore.getCertificate(alias1);
        return certificate;

    }

    /**
     * 读取P12文件获取证书
     * @param alias
     * @param pkikeyPath
     * @param keyStorePwd
     * @return
     * @throws Exception
     */
    public static Certificate getPublicKeyFromP12(String alias, String pkikeyPath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12", new BouncyCastleProvider());
        keyStore.load(new FileInputStream(pkikeyPath), keyStorePwd.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String alias1 = null;
        List<Certificate> list = null;
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
            Certificate[] certificates = keyStore.getCertificateChain(alias1);
            if(null != certificates){
                list = new ArrayList<>(Arrays.asList(certificates));
                list = sortCerts(list);
                return list.get(0);
            }
        }
        throw  new RuntimeException("解析pfx证书文件失败");

    }
    /**
     * 对证书链进行排序
     * 按照证书链倒序排列
     * 集合第一个为用户证书  最后一个为根证书
     *
     * @param certs
     * @return
     */
    public static List sortCerts(List certs) {
        if (certs.size() < 2) {
            return certs;
        }

        X500Principal issuer = ((X509Certificate) certs.get(0)).getIssuerX500Principal();
        boolean okay = true;

        for (int i = 1; i != certs.size(); i++) {
            X509Certificate cert = (X509Certificate) certs.get(i);

            if (issuer.equals(cert.getSubjectX500Principal())) {
                issuer = ((X509Certificate) certs.get(i)).getIssuerX500Principal();
            } else {
                okay = false;
                break;
            }
        }

        if (okay) {
            return certs;
        }

        // find end-entity cert
        List retList = new ArrayList(certs.size());
        List orig = new ArrayList(certs);

        for (int i = 0; i < certs.size(); i++) {
            X509Certificate cert = (X509Certificate) certs.get(i);
            boolean found = false;

            X500Principal subject = cert.getSubjectX500Principal();

            for (int j = 0; j != certs.size(); j++) {
                X509Certificate c = (X509Certificate) certs.get(j);
                if (c.getIssuerX500Principal().equals(subject)) {
                    found = true;
                    break;
                }
            }

            if (!found) {
                retList.add(cert);
                certs.remove(i);
            }
        }

        // can only have one end entity cert - something's wrong, give up.
       /* if (retList.size() > 1) {
            return orig;
        }*/

        for (int i = 0; i != retList.size(); i++) {
            issuer = ((X509Certificate) retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); j++) {
                X509Certificate c = (X509Certificate) certs.get(j);
                if (issuer.equals(c.getSubjectX500Principal())) {
                    retList.add(c);
                    certs.remove(j);
                    break;
                }
            }
        }
        // make sure all certificates are accounted for.
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }



    /**
     * 从P12中获取对应Alias的私钥
     *
     * @param alias
     * @param saveFilePath
     * @param keyStorePwd
     * @return
     * @throws Exception
     */
    public static PrivateKey getPriKeyByAliasFromP12(String alias, String saveFilePath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12", "BC");
        keyStore.load(new FileInputStream(saveFilePath), keyStorePwd.toCharArray());
        String alias1 = null;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
        }
        PrivateKey privateKey = (PrivateKey) keyStore.getKey(alias1, keyStorePwd.toCharArray());
        return privateKey;
    }

}
