package com.xdja.ra.utils;

import com.alibaba.fastjson.JSON;
import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.ra.bean.Config;
import com.xdja.ra.bean.ErrorMsg;
import com.xdja.ra.bean.Result;
import com.xdja.ra.error.ErrorBean;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.sdk.SDKService;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.*;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.KeyManagementException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * https通道
 *
 * @author wly
 */
public class SdkApacheClientUtils {

    protected static transient final Logger logger = LoggerFactory.getLogger(SdkApacheClientUtils.class);

    public static volatile CloseableHttpClient client = null;

    private static HttpClientContext contextEAS = null;

    /**
     * 通过POST的方式发送
     *
     * @param reqBody
     * @param url
     * @param contentType
     * @return
     */
    public static Result sendApacheClientRequest(byte[] reqBody, Map<String, String> paramsMap, String url, String contentType, Config config, String signData, String requestMethod) {
        Result sdkResult = SdkApacheClientUtils.exeHttpsRequest(url, reqBody, paramsMap,contentType,config,signData,requestMethod);
        return sdkResult;
    }


    /**
     * 使用apache发送https请求
     *
     * @param url
     * @param message
     * @param contentType
     * @return
     */
    private static Result exeHttpsRequest(String url, byte[] message,Map<String, String> paramsMap,  String contentType,Config config,String signData, String requestMethod) {
        byte[] body = null;
        Result result = new Result();
        boolean isHttps = SDKService.config.isHttps();
        // 获取client实例
        SdkApacheClientUtils.getClient(isHttps,config.getSignName());
        try {
            // 指定报文头Content-type、User-Agent
            URIBuilder uri = null;
            if (isHttps){
                uri = new URIBuilder("https://" + url);
            }else {
                uri = new URIBuilder("http://" + url);
            }
            CloseableHttpResponse response = null;
            HttpUriRequest httpUriRequest = null;
            ByteArrayEntity bodyEntity = null;
            // ConnectionRequestTimeout 使用连接池时，从连接池获取连接的超时时间
            // ConnectTimeout 建立连接时间，三次握手完成时间
            // SocketTimeout 数据传输过程中数据包之间间隔的最大时间
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(6000).setSocketTimeout(20000).setConnectTimeout(6000).build();
            if ("post".equalsIgnoreCase(requestMethod)){
                httpUriRequest = new HttpPost(uri.build());
                bodyEntity = new ByteArrayEntity(message);
                ((HttpPost) httpUriRequest).setEntity(bodyEntity);
            }else if ("put".equalsIgnoreCase(requestMethod)){
                httpUriRequest = new HttpPut(uri.build());
                bodyEntity = new ByteArrayEntity(message);
                ((HttpPut) httpUriRequest).setEntity(bodyEntity);
            }
            else if ("get".equalsIgnoreCase(requestMethod)){
                //get请求带参数
                if (null != paramsMap && paramsMap.size() != 0) {
                    List<NameValuePair> list = new LinkedList<NameValuePair>();
                    for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                        BasicNameValuePair param = new BasicNameValuePair(entry.getKey(), entry.getValue());
                        list.add(param);
                    }
                    uri.setParameters(list);
                }
                httpUriRequest = new HttpGet(uri.build());
                ((HttpGet) httpUriRequest).setConfig(requestConfig);
            }
            /**
             * 组装header
             */
            httpUriRequest.setHeader("Content-Type", contentType);
            httpUriRequest.setHeader("systemFlag", config.getSystemFlag());
            httpUriRequest.setHeader("timestamp", String.valueOf(System.currentTimeMillis()));
            httpUriRequest.setHeader("signAlg", config.getSignName());
            httpUriRequest.setHeader("signValue", signData);
            httpUriRequest.setHeader("signSn", config.getUserCertSn());

            // 执行请求操作，并拿到结果（同步阻塞）
            response = client.execute(httpUriRequest,contextEAS);

            // 获取响应状态
            int statusCode = response.getStatusLine().getStatusCode();
            logger.info("========== 执行调用远程状态码【" + statusCode + "】");

            // 获取结果实体
            org.apache.http.HttpEntity entity = response.getEntity();
            // 按指定编码转换结果实体为String类型
            if (entity != null) {
                body = EntityUtils.toByteArray(entity);
            }


            if (statusCode != 200) {
                if (null == body){
                    logger.error(" ========== 请求RA的外部接口返回信息为空");
                    return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_INFO_IS_EMPTY);
                }
                try {
                    ErrorBean errorBean = SdkJsonUtils.json2Object(new String(body), ErrorBean.class);
                    ErrorMsg errorMsg;
                    if (null == errorBean.getErrMsg()) {
                        errorMsg = JSON.parseObject(new String(body), ErrorMsg.class);
                        return Result.failure(errorMsg.getErrorCode(), errorMsg.getErrorMsg());
                    } else {
                        return Result.failure(errorBean.getErrCode(), errorBean.getErrMsg());
                    }

                } catch (Exception e) {
                    logger.error(" ========== 请求RA的外部接口异常信息:{}", e);
                    return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_EXCEPTION);
                }
            }

            if (body.length!=0){
                try {
                    byte[] resp = Base64.decode(body);
                    result.setInfo(resp);
                } catch (Exception e) {
                    result.setInfo(body);
                }
            }else{
                result.setInfo(null);
            }

            // 释放链接
            EntityUtils.consume(entity);
            response.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
//            try {
//                client.close();
//            } catch (IOException e) {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
        }
       return result;
    }


    private static SSLContext createIgnoreVerifySSL(String signAlgName) throws KeyManagementException, GMSSLContext.GMSSLException {
        SSLContext sc = null;
        logger.info("=============================signAlgName===================="+signAlgName);
        if (StringUtils.isBlank(signAlgName)){
            return sc;
        }
        if("SM3withSM2".equalsIgnoreCase(signAlgName)){
            sc = GMSSLContext.getClientInstance("GMSSLv1.1").getSslContext();
        }else{
            sc = GMSSLContext.getClientInstance("TLSv1.2").getSslContext();
        }

        // 实现一个X509TrustManager接口，用于绕过验证，不用修改里面的方法
        X509TrustManager trustManager = new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate,
                                           String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate,
                                           String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };

        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    /**
     * 获取client
     *
     * @return
     */
    private static CloseableHttpClient getClient(boolean isHttps, String signAlgName) {
        Registry<ConnectionSocketFactory> socketFactoryRegistry = null;
        if (client == null) {
            if (isHttps) {
                SSLContext sslcontext = null;
                // 采用绕过验证的方式处理https请求
                try {
                    sslcontext = createIgnoreVerifySSL(signAlgName);
                } catch (Exception e) {
                    logger.error("=====================", e);
                }
                // 设置协议http和https对应的处理socket链接工厂的对象
                socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                        .register("https", new SSLConnectionSocketFactory(sslcontext,
                                SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)).build();
            } else {
                // 设置协议http和https对应的处理socket链接工厂的对象
                socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                        .register("http", PlainConnectionSocketFactory.INSTANCE).build();
            }
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(500);
            connManager.setDefaultMaxPerRoute(500);

//            // 检查连接的状态，由客户端通过配置去主动关闭其认为是失效的链接
//            IdleConnectionMonitorThread idleConnectionMonitor = new IdleConnectionMonitorThread(connManager);
//            idleConnectionMonitor.start();

            // 指定链接 keep alive策略 告诉httpclient 链接大概什么时候过期 可以关闭
            ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy() {
                @Override
                public long getKeepAliveDuration(org.apache.http.HttpResponse response, HttpContext context) {
                    // Honor 'keep-alive' header
                    HeaderElementIterator it = new BasicHeaderElementIterator(
                            response.headerIterator(HTTP.CONN_KEEP_ALIVE));
                    while (it.hasNext()) {
                        HeaderElement he = it.nextElement();
                        String param = he.getName();
                        String value = he.getValue();
                        if (value != null && param.equalsIgnoreCase("timeout")) {
                            try {
                                return Long.parseLong(value) * 1000;
                            } catch (NumberFormatException ignore) {
                            }
                        }
                    }
                    return 30 * 1000;
                }
            };
            // 创建自定义的httpclient对象
            client = HttpClients.custom().setKeepAliveStrategy(myStrategy).setConnectionManager(connManager).build();
            contextEAS = HttpClientContext.create();
        }
        return client;
    }
}
