package com.xdja.ra.constant;

/**
 * 系统常量定义
 *
 * @author syg
 */
public class SdkConstants {

    /**
     * 申请类型  1:签发证书申请
     */
    public static int CERT_APPLY_TYPE_ISSUE_1 = 1;

    /**
     * 申请类型  2:更新证书申请
     */
    public static int CERT_APPLY_TYPE_UPDATE_2 = 2;

    /**
     * 申请类型  3:撤销证书申请
     */
    public static int CERT_APPLY_TYPE_REVOKE_3 = 3;
    /**
     * 申请类型  3:恢复证书申请
     */
    public static int CERT_APPLY_TYPE_RECOVERY_4 = 4;

    /**
     * 证书类型  1:单证
     */
    public static int CERT_TYPE_SINGLE_1 = 1;

    /**
     * 证书类型 2:签名证书
     */
    public static int CERT_TYPE_SIGN_2 = 2;

    /**
     * 证书类型 3:加密证书
     */
    public static int CERT_TYPE_ENC_3 = 3;


    /**
     * 签名算法 + nist 1.2.840.10045.4.3.2
     */
    public static String SIGN_ALG_NAME_SM3_WHIT_SM2 = "1.2.156.10197.1.501";
    public static String SIGN_ALG_NAME_SHA1_WHIT_RSA = "1.2.840.113549.1.1.5";
    public static String SIGN_ALG_NAME_SHA256_WHIT_RSA = "1.2.840.113549.1.1.11";
    public static String SIGN_ALG_NAME_NISTP256 = "1.2.840.10045.4.3.2";

    /**
     * 请求RA成功 200
     */
    public static int SUCCESS_CODE_200 = 200;

    /**
     * 错误码开头
     */
    public static String ERROR_CODE_400 = "400";

    /**
     * CA-SDK 错误码300 开头
     */
    public final static  String ERROR_CODE_300 = "300";


    /**
     *  秘钥格式
     *  1 -- 符合SignedAndEnvelopedData 格式的密钥  0010 规范
     * 	2 -- 符合SKF_ENVELOPEDKEYBLOB 格式的密钥  0016 规范
     */
    public static Integer KEY_FORMAT_0010_1 = 1;

    public static Integer KEY_FORMAT_0016_2 = 2;

}
