package com.xdja.ra.bean;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;

/**
 * @author: ggp
 * @Date: 2019/11/1 15:34
 * @Description:
 */
public class Config {
    /**
     * RA服务IP地址
     */
    private String serverIp;
    /**
     * RA服务端口号
     */
    private String serverPort;
    /**
     * 私钥文件路径
     */
    private String prikeyPath;
    /**
     * 私钥文件机密口令
     */
    private String priKeyPwd;
    /**
     * 信任证书链路径
     */
    private String trustCertPath;
    /**
     * 系统标识
     */
    private String systemFlag;

    /**
     * 系统私钥
     */
    private PrivateKey privateKey;

    /**
     * 系统证书
     */
    private X509Certificate systemCert;

    /**
     * 信任证书
     */
    private X509Certificate[] trustCert;

    /**
     * RA访问路径
     */
    private String raBaseUrl;

    /**
     * 系统证书sn
     */
    private String UserCertSn;

    /**
     * 系统证书签名算法oid
     */
    private String CertSignAlgOid;

    /**
     * 系统证书签名算法
     */
    private String signName;

    /**
     * 是否使用HTTPS通道
     */
    private boolean isHttps = true;

    /**
     * 是否使用密码机
     */
    private boolean isUseHsm = false;

    /**
     * 安全通信证书对象
     */
    private KeyStoreConfig keyStoreConfig;

    public boolean isHttps() {
        return isHttps;
    }

    public void setHttps(boolean https) {
        isHttps = https;
    }

    public String getServerIp() {
        return serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public String getServerPort() {
        return serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getPrikeyPath() {
        return prikeyPath;
    }

    public void setPrikeyPath(String prikeyPath) {
        this.prikeyPath = prikeyPath;
    }

    public String getPriKeyPwd() {
        return priKeyPwd;
    }

    public void setPriKeyPwd(String priKeyPwd) {
        this.priKeyPwd = priKeyPwd;
    }

    public String getTrustCertPath() {
        return trustCertPath;
    }

    public void setTrustCertPath(String trustCertPath) {
        this.trustCertPath = trustCertPath;
    }

    public String getSystemFlag() {
        return systemFlag;
    }

    public void setSystemFlag(String systemFlag) {
        this.systemFlag = systemFlag;
    }

    public PrivateKey getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getSystemCert() {
        return systemCert;
    }

    public void setSystemCert(X509Certificate systemCert) {
        this.systemCert = systemCert;
    }

    public X509Certificate[] getTrustCert() {
        return trustCert;
    }

    public void setTrustCert(X509Certificate[] trustCert) {
        this.trustCert = trustCert;
    }

    public String getRaBaseUrl() {
        return raBaseUrl;
    }

    public void setRaBaseUrl(String raBaseUrl) {
        this.raBaseUrl = raBaseUrl;
    }

    public String getUserCertSn() {
        return UserCertSn;
    }

    public void setUserCertSn(String userCertSn) {
        UserCertSn = userCertSn;
    }

    public String getCertSignAlgOid() {
        return CertSignAlgOid;
    }

    public void setCertSignAlgOid(String certSignAlgOid) {
        CertSignAlgOid = certSignAlgOid;
    }

    public String getSignName() {
        return signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public KeyStoreConfig getKeyStoreConfig() {
        return keyStoreConfig;
    }

    public void setKeyStoreConfig(KeyStoreConfig keyStoreConfig) {
        this.keyStoreConfig = keyStoreConfig;
    }

    public boolean isUseHsm() {
        return isUseHsm;
    }

    public void setUseHsm(boolean useHsm) {
        isUseHsm = useHsm;
    }
}
