package com.xdja.ra.bean;

import java.util.List;

/**
 * @author: ggp
 * @Date: 2019/10/22 18:15
 * @Description:
 */
public class IssueApply {
    /**
     * 非必须	申请原因
     */
    private String applyReason;
    /**
     * 必须	证书Dn (DN的后缀需为当前RA系统的BaseDn，该BaseDn可通过接口或离线方式获知)
     */
    private String certDn;

    /**
     * 必须
     */
    private Integer certValidity;
    /**
     * 非必须	密钥长度 （RSA:1024/2048 SM2:256）
     */
    private Integer privateKeyLength;
    /**
     * 非必须	签名算法 （SHA-1WITHRSA / SHA256WITHRSA / SM3WITHSM2）
     */
    private String signAlg;
    /**
     * 必须	模板编号 (该编号可通过接口或离线的方式获知)
     */
    private String tempNo;

    /**
     * 非必须	模板中用户填入扩展项信息 (该参数需填入内容可通过接口或离线的方式获知)
     */
    private List<Extension> extensionList;

    /**
     * 必须	1-个人用户 2-机构用户 3-设备用户
     */
    private Integer userType;
    /**
     * 必须	不同类型用户相对应的用户身份类型 userType为1时 identType 1:身份证 2:军官证  3:护照 4:其它 userType为2时 identType 1:工商登记证 2:组织机构代码 3:税务登记证 4:其他 userType为3时 identType 1:服务器 2:手机 3:网站 4:其他
     */
    private Integer licenseType;

    /**
     * 必须 不同身份类型的唯一编号
     */
    private String licenseNumber;

    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public String getCertDn() {
        return certDn;
    }

    public void setCertDn(String certDn) {
        this.certDn = certDn;
    }

    public Integer getCertValidity() {
        return certValidity;
    }

    public void setCertValidity(Integer certValidity) {
        this.certValidity = certValidity;
    }

    public Integer getPrivateKeyLength() {
        return privateKeyLength;
    }

    public void setPrivateKeyLength(Integer privateKeyLength) {
        this.privateKeyLength = privateKeyLength;
    }

    public String getSignAlg() {
        return signAlg;
    }

    public void setSignAlg(String signAlg) {
        this.signAlg = signAlg;
    }

    public String getTempNo() {
        return tempNo;
    }

    public void setTempNo(String tempNo) {
        this.tempNo = tempNo;
    }

    public Integer getLicenseType() {
        return licenseType;
    }

    public void setLicenseType(Integer licenseType) {
        this.licenseType = licenseType;
    }

    public List<Extension> getExtensionList() {
        return extensionList;
    }

    public void setExtensionList(List<Extension> extensionList) {
        this.extensionList = extensionList;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getLicenseNumber() {
        return licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    @Override
    public String toString() {
        return "IssueApply{" +
                "applyReason='" + applyReason + '\'' +
                ", certDn='" + certDn + '\'' +
                ", certValidity=" + certValidity +
                ", privateKeyLength=" + privateKeyLength +
                ", signAlg='" + signAlg + '\'' +
                ", tempNo='" + tempNo + '\'' +
                ", extensionList=" + extensionList +
                ", userType=" + userType +
                ", licenseType=" + licenseType +
                ", licenseNumber='" + licenseNumber + '\'' +
                '}';
    }
}
